class EditFieldChooser {
    #field;
    #searchName;
    #searchField;
    #objectType;

    constructor(objectType, field, searchName, searchField) {
        this.#searchField = searchField;
        this.#searchName = searchName;
        this.#field = field;
        this.#objectType = objectType;
    }


    showEditFieldWindow(ids, currentStatus, list) {
        let remoteChooserDiv = h.div('remote_selection')
        let remoteChooserInput = h.input(dom.HIDDEN).text(currentStatus, false)
        let modal = h.div("modal");
        let form = h.div("modal_prompt").add(modal).appendToBody();

            modal.add(h.div('title').text("global.page.issue.menu_" + this.#field + ".form.title"))
            .add(h.div('status').add(h.span('status_label', 'global.page.issue.menu_' + this.#field + '.form.field_text', true)).add(remoteChooserDiv))
            .add(h.div('actions').add(h.input('button').text('global.ok').cl('apply').click(() => {

                _.each(ids, id => {
                    let path = Environment.dataApi + "/api/v2/flaw/" + this.#objectType + "/edit_field/id/" + id;
                    Executor.runPutWithPayload(path, () => {
                        list.drawValues()
                        form.remove()
                    }, {"key": this.#field, "value": parseInt(remoteChooserInput.val())})
                })

            })))


        modal.add( dom.createCloseImage().click(() => {
            form.remove()
        }))


        let chooser = new MagicRemoteChooser(remoteChooserDiv, {}, remoteChooserInput, 'dataType', this.createHeaderForChooser());
        if (currentStatus != null) {
            chooser.getDataById(currentStatus, this.#searchName)
        }
    }


    createHeaderForChooser() {
        let _this = this;
        return {
            getData() {
                return {
                    searchName: _this.#searchName,
                    searchField: _this.#searchField,
                };
            },
            getField() {
                return _this.#searchName;
            },

            getType() {
                return EditFlow.OBJECT_CHOOSER;
            },
        };

    }


}