class WC_OPTIONS {
  static WORKING_DAY_CLASS = "working_day";
  static WEEKEND_CLASS = "weekend";
  static DAY_CONTAINER_CLASS = "day_container";
  static DAY_CLASS = "day";
  static HOURS_CLASS = "hours";

  static DAYS = [ 'mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun' ];

  static TYPES_OF_DAYS = ['work', 'week', ''];

  
}

class WorkCalendarDay{
  #dayContainer = h.div("working_day day_container inline pointer");
  #dayDiv = h.div("day").appendTo(this.#dayContainer);
  #hoursDiv = h.div("hours").appendTo(this.#dayContainer);

  #day;
  #hours;
  #parent;

  constructor(day, hours, parent) {
    this.#day = day;
    this.#hours = hours;
    this.#parent = parent;

    this.#dayContainer.click( () => this.#parent.dayClick(this))
  }

  getContainer(){
    return this.#dayContainer;
  }

  buildDayDiv() {
    this.#dayDiv.text(this.#day, false);

    this.#hoursDiv
      .add(h.span(WorkCalendar.CLASS + 'hours-in-day').text(this.#hours, false))
      .add(h.span(WorkCalendar.CLASS + 'h').text(WorkCalendar.TRANSLATE + 'hour'));

    return this.#dayContainer;
  }

  getHours(){
    return this.#hours;
  }
}

class WorkCalendar {
  static CLASS = "wc__";
  static TRANSLATE = "pages.work_calendar."

  #where;

  #wrapper = h.div( WorkCalendar.CLASS + "wrapper");
  #title = h.div("page_title").text('pages.menu.working_calendar').appendTo(this.#wrapper);
  #header = h.div(WorkCalendar.CLASS + 'header').appendTo(this.#wrapper);
  #chooserDivH = h.div(WorkCalendar.CLASS + 'chooser time_input').pointer().id("date-chooser").appendTo(this.#header);
  #hidenCheckbox = h.input("checkbox").id('allow-short').hide().appendTo(this.#header);
  #checkboxLabel = h.label('allow-short', WorkCalendar.TRANSLATE + '.short.days').appendTo(this.#header);
  #saveBtn = h.div('calendar_save_button').text(WorkCalendar.TRANSLATE + 'save').appendTo(this.#header)
  #weekDays = h.div(WorkCalendar.CLASS + 'weekdays').appendTo(this.#wrapper);
  #daysWrapper = h.div(WorkCalendar.CLASS + "calendar").appendTo(this.#wrapper); 
  #totalBlock = h.div(WorkCalendar.CLASS + "total total").appendTo(this.#wrapper);
  #totalSpan = h.span(WorkCalendar.CLASS + "total-span").text(WorkCalendar.TRANSLATE + 'total').appendTo(this.#totalBlock);
  #totalCountSpan = h.span(WorkCalendar.CLASS + "total-count").appendTo(this.#totalBlock);

  #total = 0;
  #chooser;
  #clieckedDay;

  #daysArray = [];
  #monthState = getMonthDays();

  constructor(where) {
    this.#where = where;
  }


  init() {
    this.drawWeekDays();

    this.#wrapper.appendTo(this.#where);
    
    this.initChooser();

    this.initDayChooser();

    this.drawCalendar();
  }

  setClickedDay(val) {
    this.#clieckedDay = val; 
  }

  initDayChooser(){
    let header = {
      getData() {
          return {
              searchName: 'issue_status',
              searchField: 'name',
          };
      },
      getField() {
          return 'status';
      },
      getType() {
          return EditFlow.OBJECT_CHOOSER;
      },
    };

    let remoteChooserDiv = h.div('remote_selection');

    let remoteChooserInput = h.input(dom.HIDDEN);

    this.#chooser = new MagicRemoteChooser(remoteChooserDiv, {}, remoteChooserInput, 'dataType', header, this );
  }

  openChooser = () => {
    this.#chooser.showForm();
  }

  getFormFieldListener(){
    return (event) =>{
      if(_e(event.type, MagicRemoteChooser.EVENT_ITEM_SELECTED)){
        console.log(event, this.#clieckedDay);
      }
    }
  }

  drawTotal() {
    this.#total = this.buildTotal();

    this.#totalCountSpan.text(this.#total, false);
  }

  drawCalendar() {
    this.#daysWrapper.text(null);

    this.presetEmptyDiv();

    this.drawDays();

    this.drawTotal();
  }

  drawWeekDays(){
    _.each(DateOptions.WEEKDAYS, (day) => {
      h.div('weekday').text(day).appendTo(this.#weekDays)
    })
  }

  presetEmptyDiv(){
    _.each(WC_OPTIONS.DAYS, (day, index) => {
      
      if(_e(day, this.#monthState[0].day)) {

        for(let i = 0; i < index; i++) {
          h.div('inline ' + WC_OPTIONS.DAY_CONTAINER_CLASS).appendTo(this.#daysWrapper);
        }

        return;
      }
    })
  }

  initChooser(){
    const options = new DateOptions(this.#chooserDivH, ".", "mm.yyyy", "", this.dateListener)

    new MagicDateChooser(options).init();

    let date = MagicDateChooser.getToday().split(".");

    this.#chooserDivH.text(date[1] + '.' + date[2], false) 
  }

  dateListener = (event) => {
    if(_.e(DateEvent.DATE_SELECTED, event.eventName )){
      this.refreshParams();

      let month = event.data.split(".")[0] - 1;

      let year = Number(event.data.split(".")[1]);
      
      this.#monthState = getMonthDays(year, month);

      this.drawCalendar();
    }   
  }

  dayClick(day){
    this.#clieckedDay = day;

    this.openChooser();
  }

  refreshParams(){
    this.#daysArray = [];

    this.#total = 0;

    this.#monthState = []
  }

  drawDays() {
    _.each(this.#monthState, (day) => {

      let wcDay = new WorkCalendarDay(day.date, 8, this);
      
      wcDay.buildDayDiv().appendTo(this.#daysWrapper);

      this.#daysArray.push(wcDay)
    });

  }

  buildTotal() {
    for (let i = 0; i < this.#daysArray.length; i++) {
      this.#total += parseInt(this.#daysArray[i].getHours());
    }

    return this.#total; 
  }

}

const formatter = new Intl.DateTimeFormat("en-US", {
  weekday: "short",
});

const getMonthDays = (year = new Date().getFullYear(), month = new Date().getMonth()) => {

  const date = new Date(year, month + 1, 0);
  const count = date.getDate();
  const days = [];

  for (let day = 1; day <= count; day++) {
    date.setDate(day);

    days.push({
      day: formatter.format(date).toLocaleLowerCase(),
      date: date.getDate(),
    });
  }

  return days;
};
