function showChangePassword() {
  get("change_password").classList.remove("hidden");
}

function closeChangePasswordForm() {
  get("change_password").classList.add("hidden");
}

function changePassword() {
  ____USER.changePassword(
      document.getElementById("login").value,
      document.getElementById("password").value,
      document.getElementById("twoFactorCode").value,
      document.getElementById("newPassword").value,
      document.getElementById("passwordRepeat").value
  );
}

function changePasswordIfRequired(e) {
  if (e.keyCode == 13) {
      changePassword();
  }
}

var ____qrText = "";

function show2factSettings() {
    var path = Environment.authApi + "/api/v3/auth/2factCode";

    var enable = h.fromId("auth2fEnabled");
    var settings = h.fromId("_2factSettings");

    Executor.runGet(path, (data) => {
      show2factQrCode(data.code);
      if (data.enabled) {
        enable.attr("checked", true);
      } else {
        enable.attr("checked", false);
      }

      settings.show();
    }, true, Executor.HEADERS, (e) => {
      try {
        let data = JSON.parse(e.responseText);

        show2factQrCode(data.code);
        if (data.enabled) {
          enable.attr("checked", true);
        } else {
          enable.attr("checked", false);
        }
        settings.show();
        return;
    } catch (Exc) {
        console.log({Exc});
    }

    dom.toast(html.translate("global.exception") + e);
    })
}

function saveAuthType() {
    var enabledElement = h.fromId("auth2fEnabled");
    let enabled = enabledElement.checked();

    let path = Environment.authApi + "/api/v3/auth/2factCode/" + enabled;

    var success = (data) => {
      if(data.enabled) {
        enabledElement.attr("checked", true);
      } else {
        enabledElement.attr("checked", false);
      }

      h.fromId("_2factSettings").hide();
    }

    var fail = (e) => {
      try {
        let data = JSON.parse(e.responseText);

        if(data.enabled) {
          enabledElement.attr("checked", true);
        } else {
          enabledElement.attr("checked", false);
        }
  
        h.fromId("_2factSettings").hide();
        return;
      } catch (Exc) {
          console.log({Exc});
      }

      dom.toast(html.translate("global.exception") + e);
    }

    
    Executor.runPost(path, success, Executor.HEADERS, true, fail)
}

function show2factQrCode(code, el = "___qr") {
    get(el).innerHTML = "";
    const qrcode = new QRCode(el, {
        text: code,
        width: 128,
        height: 128,
        colorDark: "#C2CF91",
        colorLight: "#ffffff",
        correctLevel: QRCode.CorrectLevel.H,
    });
}

getLanguages();

function getLanguages() {
  const panelClass = ".dropdown-content22-language-menu";

  let panel = h.fromFirst(panelClass);

  let payload = new MagicRequest();

    payload.query[0] =   {
      "field": "active",
      "value": true,
      "searchName": "active",
      "dataType": "object_chooser",
      "type": "="
    }

  panel.text(null)

  Executor.runPostWithPayload(Environment.dataApi + '/api/v2/flaw/language/root/fetch/data/', (data) => {

    _.each(data.content, (item) => {

      let link = h.tag("a").click(() => {
        ____USER.changeLanguage(item.code)
      })

      link.add(h.div('language').text(item.name, false).cl("lang_" + item.code));

      panel.add(link);
    });

    
  }, payload, (e) => {
  })
}