function openCreateModal(event) {
  document.getElementById("create-modal").style.display = "flex";
  h.fromId("add-btn-arrow").cl("rotated");
}

function closeCreateModal(event) {
  if (event.target.id === "create-modal") event.target.style.display = "none";
  h.fromId("add-btn-arrow").rcl("rotated")
}

function openPersonModal() {
  document.getElementById("person-modal").style.display = "flex";
}

function closePersonModal(event) {
  if (event.target.id === "person-modal") event.target.style.display = "none";
}

let notificationButton = document.getElementById("notification_btn");
let notificationList = h.from(document.getElementById("notification_list"));
let notificationBoxWr = document.getElementById("notification_box_wr");
let notificationBox = document.getElementById("notification_box");
let notificationBoxRm = document.getElementById("notification_box_rm");

let modalName = "modal_" + new Date().getTime() + Math.ceil(Math.random() * (1000 - 1) + 1);
h.from(notificationBoxWr).setData(dom.MODAL, modalName).click(()=>{
  MagicPage.focusModal(modalName)
})

MagicPage.setModal(modalName, h.from(notificationBoxWr), dom.REMOVE_TYPE_HIDE)

if (_.notNull(notificationBoxRm) ) {
  notificationBoxRm.onclick = function () {
    h.from(notificationBoxWr).hideModal()
  };
}

if (_.notNull(notificationBox) ) {
  notificationBox.onclick = function (e) {
    e.stopPropagation()
  };
}

if (_.notNull(notificationBoxWr) ) {
  notificationBoxWr.onclick = function () {
    h.from(notificationBoxWr).hideModal()
  };
}

_.each(document.getElementsByClassName('current-group'), (el)=> {
  h.from(el).text(null).add(Group.drawGroup())
})

function checkNotifList() {
  if (!notificationList.val()) {
    notificationList.innerHTML = html.translate("No notification");
  }
}
if (_.notNull(notificationButton) ) {
  notificationButton.onclick = function () {
    let path = Environment.dataApi + "/api/v2/flaw/user_notification/my";
    Executor.runGet(path, function (data) {
      buildNotification(data);
    });
  };
}

function create(where, path) {

  let magicFormOptions = new MagicFormOptions("flaw/" + path, )
  magicFormOptions.setFormFieldListener(Group.selectGroupListener);
  magicFormOptions.setFormListener(Group.preselectingGroupListener)
  MagicForm.Instance(  path, magicFormOptions).load();
}


function buildNotification(data) {
  if(notificationBoxWr.classList.contains("hidden")){
    h.from(notificationBoxWr).showModal();
  }else{
    h.from(notificationBoxWr).hideModal();
  }
  let item = data.content;
  notificationList.text(null);
  for (let i = 0; i < item.length; i++) {
    let myNoti = h.div("my_noti");
    myNoti.text(item[i].text, false);
    let closeImg = h.img("delete.png", 24);
    let notifId = item[i].id;
    myNoti.add(closeImg).appendTo(notificationList);

    closeImg.onclick = function (id) {
      Issue.deleteNotification(function () {
        h.remove();
      }, notifId);
      checkNotifList();
    };
  }
  checkNotifList();
}

function checkNotifList() {
  if (notificationList.innerHTML == "") {
    notificationList.innerHTML = html.translate("No notification");
  }
}

function toggleMenu() {
  let isMenuOpen = PersonalSettings.getSetting('isMenuOpen');
  if(utils.e(isMenuOpen, 'false')) {
    isOpen = false;
  } else {
    showMenu();
    isOpen = true;
  }
  
  const menu = h.from(document.querySelector(".vertical_menu"));
  const btnToggle = h.from(document.querySelector(".toggle-menu"));
  const btnImg = h.from(document.getElementById('toggle-menu-icon'));


  btnToggle.click( () => {
    menu.toggle("open-menu");
    if (isOpen) {
      btnImg.get().src = Environment.self + "/images/menu_open.svg";
      PersonalSettings.setSetting('isMenuOpen', 'false', (data) => {
      });
    } else {
      btnImg.get().src = Environment.self + "/images/menu_close.svg";
      PersonalSettings.setSetting('isMenuOpen', 'true', (data) => {
      });
    }
    isOpen = !isOpen;
  });
}

function showMenu(){
  const menu = h.from(document.querySelector(".vertical_menu"));
  let column = menu.first()
  column.eachOf(((el) => {
    if(el.tagName){
      el.classList.toggle('noTransition');
    }
  }))
  
  const btnToggle = document.querySelector(".toggle-menu");
  const btnImg = h.from(btnToggle.children[0]);
  menu.toggle('noTransition');
  menu.toggle("open-menu");
  btnImg.get().src = Environment.self + "/images/menu_close.svg";

  setTimeout(() => {
    column.eachOf(((el) => {
      if(el.tagName){
        el.classList.toggle('noTransition');
        menu.toggle('noTransition');
      }
    }))
  }, 0);
}

if (Environment.isNotRegisterLoginOrReset()) {
  try {
    toggleMenu();
  } catch (e){
   
  }
}

    h.fromId("menu-item-add").click(()=>{
      let magicFormOptions = new MagicFormOptions('flaw/group');
      magicFormOptions.setFormListener(formListner);
      MagicForm.Instance('flaw/group', magicFormOptions).load();
    })
  
    function formListner(event){
      if(_.e(event.type, MagicFormEvent.FORM_SAVED)){
        try {
          drawMyGroups(Group.GROUPS_PANEL_ID, "menu-item");
        } catch (e) {}
      }
    }
    