/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.client.RestTemplate;
import systems.dennis.shared.config.MessageResourceSource;

@SpringBootApplication(scanBasePackages={"systems.dennis.shared*", "systems.dennis.auth"})
@EntityScan(value={"systems.dennis.*"})
@EnableJpaRepositories(value={"systems.dennis.*"})
@CrossOrigin
public class AuthApp {
    private final MessageResourceSource resourceSource;

    public AuthApp(MessageResourceSource resourceSource) {
        this.resourceSource = resourceSource;
    }

    public static void main(String[] args) {
        SpringApplication.run(AuthApp.class, (String[])new String[0]);
    }

    @Bean
    @Primary
    public MessageSource messageSource() {
        this.resourceSource.setBasename("messages");
        this.resourceSource.setDefaultEncoding("UTF-8");
        return this.resourceSource;
    }

    @Bean
    WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> enableDefaultServlet() {
        return factory -> factory.setRegisterDefaultServlet(true);
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

