/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.shared.entity.BaseEntity;

@Entity
public class LoginPassword
extends BaseEntity {
    @Column(columnDefinition="varchar(500)")
    private String login;
    @Column(columnDefinition="varchar(2000)")
    private String password;
    private String domain;
    private Boolean twoFactor;
    private String twoFactorCode;
    @Transient
    private boolean updatable;

    public static LoginPassword from(RegistrationForm form) {
        LoginPassword loginPassword = new LoginPassword();
        loginPassword.setLogin(form.getEmail());
        loginPassword.setPassword(form.getPassword());
        loginPassword.setTwoFactor(Boolean.FALSE);
        return loginPassword;
    }

    public String asValue() {
        return this.login;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public Boolean getTwoFactor() {
        return this.twoFactor;
    }

    public String getTwoFactorCode() {
        return this.twoFactorCode;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setTwoFactor(Boolean twoFactor) {
        this.twoFactor = twoFactor;
    }

    public void setTwoFactorCode(String twoFactorCode) {
        this.twoFactorCode = twoFactorCode;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPassword)) {
            return false;
        }
        LoginPassword other = (LoginPassword)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUpdatable() != other.isUpdatable()) {
            return false;
        }
        Boolean this$twoFactor = this.getTwoFactor();
        Boolean other$twoFactor = other.getTwoFactor();
        if (this$twoFactor == null ? other$twoFactor != null : !((Object)this$twoFactor).equals(other$twoFactor)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$twoFactorCode = this.getTwoFactorCode();
        String other$twoFactorCode = other.getTwoFactorCode();
        return !(this$twoFactorCode == null ? other$twoFactorCode != null : !this$twoFactorCode.equals(other$twoFactorCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginPassword;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdatable() ? 79 : 97);
        Boolean $twoFactor = this.getTwoFactor();
        result = result * 59 + ($twoFactor == null ? 43 : ((Object)$twoFactor).hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $twoFactorCode = this.getTwoFactorCode();
        result = result * 59 + ($twoFactorCode == null ? 43 : $twoFactorCode.hashCode());
        return result;
    }

    public String toString() {
        return "LoginPassword(login=" + this.getLogin() + ", password=" + this.getPassword() + ", domain=" + this.getDomain() + ", twoFactor=" + this.getTwoFactor() + ", twoFactorCode=" + this.getTwoFactorCode() + ", updatable=" + this.isUpdatable() + ")";
    }
}

