/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.remote;

import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.config.AuthorizeResponse;
import systems.dennis.auth.exception.NeedAuthorizationException;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;

@Service
@ConditionalOnExpression(value="${global.auth.client.enabled:false}")
public class AuthClient {
    private final RestTemplate restTemplate;
    private final WebContext context;

    public AuthClient(RestTemplate restTemplate, WebContext context) {
        this.restTemplate = restTemplate;
        this.context = context;
    }

    public String login() {
        UserTokenDTO res = this.getVirtualToken(this.getServerLogin(), this.getServerPassword());
        if (res == null) {
            throw new AccessDeniedException("User login password is incorrect");
        }
        return res.getToken();
    }

    public String login(String userName, String userPassword, String authCode) {
        UserTokenDTO res = this.getToken(userName, userPassword, authCode);
        if (res == null) {
            throw new NeedAuthorizationException();
        }
        return res.getToken();
    }

    public UserTokenDTO getVirtualToken(String login, String password) {
        try {
            LoginPassword param = new LoginPassword();
            param.setPassword(password);
            param.setLogin(login);
            HttpHeaders headers = new HttpHeaders();
            headers.set("AUTH_TYPE", "VIRTUAL");
            headers.set("AUTH_SCOPE", this.getScopeId());
            HttpEntity request = new HttpEntity((Object)param, (MultiValueMap)headers);
            ResponseEntity res = this.restTemplate.postForEntity(this.getAuthPath() + "/login", (Object)request, AuthorizeResponse.class, new Object[0]);
            if (res.getStatusCode() == HttpStatus.FORBIDDEN) {
                throw new AccessDeniedException("User login password is incorrect");
            }
            if (res.getBody() == null) {
                throw new RuntimeException("not able to get ->  result status: " + String.valueOf(res.getStatusCode()));
            }
            return ((AuthorizeResponse)res.getBody()).getDto();
        }
        catch (HttpClientErrorException.Forbidden e) {
            throw new AccessDeniedException("User login password is incorrect");
        }
    }

    private UserTokenDTO getToken(String login, String password, String authCode) {
        try {
            LoginPassword param = new LoginPassword();
            param.setPassword(password);
            param.setLogin(login);
            param.setTwoFactorCode(authCode);
            ResponseEntity res = this.restTemplate.postForEntity(this.getAuthPath() + "/login", (Object)param, UserTokenDTO.class, new Object[0]);
            if (res.getStatusCode() == HttpStatus.FORBIDDEN) {
                throw new AccessDeniedException("User login password is incorrect");
            }
            if (res.getBody() == null) {
                throw new RuntimeException("not able to get ->  result status: " + String.valueOf(res.getStatusCode()));
            }
            return (UserTokenDTO)res.getBody();
        }
        catch (HttpClientErrorException.Forbidden e) {
            throw new AccessDeniedException("User login password is incorrect");
        }
    }

    private String getServerLogin() {
        return (String)this.context.getEnv("servers.central.user");
    }

    private String getServerPassword() {
        return (String)this.context.getEnv("servers.central.password");
    }

    private String getRegisterLink() {
        return (String)this.context.getEnv("pages.auth.register_link", (Object)"/register/add");
    }

    private String getRestoreLink() {
        return (String)this.context.getEnv("pages.auth.restore_link", (Object)"/auth/profile/restore");
    }

    private String getAuthPath() {
        return (String)this.context.getEnv("servers.auth.path");
    }

    private String getScopeId() {
        return this.context.getEnv("dennis.systems.security.scope.id").toString();
    }
}

