/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.remote;

import java.util.Objects;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.remote.AuthClient;
import systems.dennis.shared.config.WebConstants;

@Controller
@RequestMapping(value={"/client_login"})
public class ClientAuthController {
    private final AuthClient client;

    public ClientAuthController(AuthClient client) {
        this.client = client;
    }

    @GetMapping
    public String start(@RequestParam(required=false) String message, Model model, WebRequest request) {
        if (message != null) {
            model.addAttribute("message", (Object)message);
        }
        model.addAttribute("item", (Object)new LoginPassword());
        return WebConstants.asPage((String)"/login", (String)"/login");
    }

    @PostMapping
    public String login(@RequestParam(required=false) String message, @ModelAttribute(value="item") LoginPassword pwd, Model model, WebRequest request) {
        LoginPassword password = (LoginPassword)model.getAttribute("item");
        if (message != null) {
            model.addAttribute("message", (Object)message);
        }
        if (password == null) {
            return WebConstants.asPage((String)"/login", (String)"");
        }
        try {
            String res = this.client.login(password.getLogin(), password.getPassword(), password.getTwoFactorCode());
            if (res == null) {
                return WebConstants.withMessage((String)"user_not_found", (String)WebConstants.asRedirect((String)"/client_login", (String)""));
            }
            model.addAttribute("___token___", (Object)res);
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("not able")) {
                return WebConstants.withMessage((String)"user_not_found", (String)WebConstants.asRedirect((String)"/client_login", (String)""));
            }
            return WebConstants.withMessage((String)e.getMessage(), (String)WebConstants.asRedirect((String)"/client_login", (String)""));
        }
        String url = String.valueOf(request.getAttribute("redirect", 1));
        if (!Objects.equals(url, "null")) {
            return WebConstants.asRedirect((String)"", (String)url);
        }
        return WebConstants.asRedirect((String)"/", (String)"");
    }
}

