/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.NeedAuthorizationException;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.UserServiceImpl;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.utils.Supplier;

@Service
public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private final WebContext context;
    private boolean authorized = false;

    public AuthenticationService(WebContext context) {
        this.context = context;
    }

    public UserTokenDTO authorize(LoginPassword loginPassword, ScopeModel scope) {
        if (this.authorized) {
            this.logout();
        }
        UserTokenDTO res = ((UserServiceImpl)this.context.getBean(UserServiceImpl.class)).authorize(loginPassword, scope);
        this.authorized = true;
        SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        return res;
    }

    public UserTokenDTO authorizeVirtual(LoginPassword loginPassword, ScopeModel scope) {
        if (this.authorized) {
            this.logout();
        }
        UserTokenDTO res = ((UserServiceImpl)this.context.getBean(UserServiceImpl.class)).authorizeVirtual(loginPassword, scope);
        this.authorized = true;
        SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        return res;
    }

    public boolean logout() {
        try {
            if (!this.authorized) {
                return false;
            }
            SecurityContextHolder.getContext().setAuthentication(null);
            this.authorized = false;
            return true;
        }
        catch (Exception e) {
            log.error("Something wrong goes with logout: ", (Throwable)e);
            return false;
        }
    }

    boolean isAuthorized() {
        return this.authorized;
    }

    public UserTokenDTO get() throws NeedAuthorizationException {
        Authentication res = SecurityContextHolder.getContext().getAuthentication();
        if (!(res instanceof UserTokenDTO)) {
            throw new NeedAuthorizationException();
        }
        return (UserTokenDTO)res;
    }

    public TokenData getToken(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String token = request.getHeader(AUTHORIZATION_HEADER);
        String tokenScope = request.getHeader("AUTH_SCOPE");
        if (token == null) {
            token = this.get(() -> new AuthorizationNotFoundException("Expected token, instead no token")).getToken();
        }
        token = token.replace("Bearer ", "").trim();
        return new TokenData(tokenScope, token);
    }

    private UserTokenDTO get(Supplier<? extends Exception> o) {
        try {
            return this.get();
        }
        catch (NeedAuthorizationException e) {
            throw (Exception)o.onNull();
        }
    }

    public String restore(String login, WebContext.LocalWebContext context) {
        UserDataRepository userRepo = (UserDataRepository)context.getBean(UserDataRepository.class);
        PasswordService passwordService = (PasswordService)context.getBean(PasswordService.class);
        UserData dta = (UserData)userRepo.findByLogin(login).orElseThrow(() -> new ItemNotFoundException(login));
        return passwordService.reset(dta);
    }

    public boolean hasRole(String role) {
        return this.get().getRoleList().stream().map(UserRole::getRole).collect(Collectors.toList()).contains(role);
    }
}

