/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import systems.dennis.auth.client.utils.RoleValidationType;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.client.utils.TokenValidator;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.NoCondition;
import systems.dennis.shared.annotations.security.PermissionCheck;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.annotations.security.WithRoles;
import systems.dennis.shared.annotations.security.selfchecker.AbstractSelfChecker;
import systems.dennis.shared.annotations.security.selfchecker.NoChecker;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;

@Aspect
public abstract class BasicAuthAoe
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthAoe.class);
    private final TokenValidator tokenValidator;

    public BasicAuthAoe(TokenValidator tokenValidator, WebContext context) {
        super(context);
        log.debug("Initializing Basic auth... ");
        this.tokenValidator = tokenValidator;
    }

    @Pointcut(value="execution(public * *(..))")
    public void anyPublicMethod() {
    }

    @Pointcut(value="@annotation(systems.dennis.shared.annotations.security.WithRole)")
    public void withRole2() {
    }

    @Before(value="withRole2()")
    public void beforeAdvice(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getAnnotation(WithRole.class) == null) {
            return;
        }
        log.debug("In method: " + method.getName());
        Object[] values = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        if (this.checkPermission(method, target, values)) {
            return;
        }
        this.runAllSecurityAnnotations(method, values, target);
        this.checkSelf(method, target, values);
    }

    private boolean checkPermission(Method method, Object target, Object[] values) {
        Class cl = method.getAnnotation(WithRole.class).ignoreOnCondition();
        if (cl == NoCondition.class) {
            return false;
        }
        try {
            PermissionCheck instance = (PermissionCheck)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (target instanceof SearchEntityApi) {
                String type = String.valueOf(values[0]);
                AbstractService correctTarget = (AbstractService)this.getBean(SearchEntityApi.findServiceByType((String)type));
                return instance.checkIgnorePermission(values, (Object)correctTarget, this.getContext());
            }
            return instance.checkIgnorePermission(values, target, this.getContext());
        }
        catch (Exception e) {
            log.error("Error during permission check: " + e.getMessage());
            return false;
        }
    }

    private void checkSelf(Method method, Object target, Object[] values) {
        SecurityUtils utils = (SecurityUtils)this.getContext().getBean(SecurityUtils.class);
        if (method.getAnnotation(SelfOnlyRole.class) == null) {
            return;
        }
        WebFormsSupport ann = target.getClass().getAnnotation(WebFormsSupport.class);
        if (ann == null) {
            throw new IllegalArgumentException("Self check can be applied to object that contains interface RepoService ");
        }
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("Self role without ID detection, very strange....");
        }
        int arg = -1;
        if (parameters.length == 1) {
            arg = 0;
        }
        Id idAnnotation = null;
        int parametersLength = parameters.length;
        for (int i = 0; i < parametersLength; ++i) {
            Parameter p = parameters[i];
            if (p.getAnnotation(Id.class) == null) continue;
            arg = i;
            idAnnotation = p.getAnnotation(Id.class);
            break;
        }
        if (arg == -1) {
            throw new IllegalArgumentException("NO @ID for the argument, haven't your forgot to add one? " + String.valueOf(method));
        }
        AbstractService bean = (AbstractService)this.getBean(ann.value());
        DefaultForm entity = null;
        if (values[arg] instanceof DefaultForm) {
            entity = (DefaultForm)values[arg];
            try {
                boolean isUsers = bean.getByIdAndUserDataId(entity.getId(), this.getCurrentUser());
                if (!isUsers) {
                    bean.checkMy(bean.findByIdOrThrow(entity.getId()));
                }
            }
            catch (Exception e) {
                throw new ItemNotUserException();
            }
            return;
        }
        entity = bean.findByIdOrThrow((Long)values[arg]);
        if (!(entity instanceof UserAssignableEntity)) {
            if (idAnnotation != null) {
                if (idAnnotation.checker() == NoChecker.class) {
                    log.info("Entity of class: " + String.valueOf(entity.getClass()) + " is not really instance of UserAssignableEntity");
                } else {
                    AbstractSelfChecker checker = (AbstractSelfChecker)idAnnotation.checker().getConstructor(new Class[0]).newInstance(new Object[0]);
                    checker.check((Authentication)utils.get(), (Object)entity, this.getContext());
                }
            }
        } else {
            utils.isMy((Object)entity);
        }
    }

    private void runAllSecurityAnnotations(Method method, Object[] values, Object target) {
        HttpServletRequest request = this.getContext().getRequest();
        if (request == null) {
            log.error("No HttpServletRequest");
            log.error("HttpServletRequest is not existing on " + target.getClass().getName());
            return;
        }
        ArrayList requestedRoles = new ArrayList();
        requestedRoles.addAll(this.getRolesByAnnotation(method, request));
        requestedRoles.addAll(this.additionalRoles(target));
        this.tokenValidator.validate(request, requestedRoles, RoleValidationType.ALL);
    }

    private List<String> getRolesByAnnotation(Method method, HttpServletRequest request) {
        WithRoles withRoles;
        WithRole withRole = method.getAnnotation(WithRole.class);
        if (withRole != null) {
            if (!withRole.or().equals("")) {
                try {
                    this.tokenValidator.validate(request, Collections.singletonList(withRole.value()), RoleValidationType.ALL);
                }
                catch (Exception e) {
                    return Collections.singletonList(withRole.or());
                }
            } else {
                return Collections.singletonList(withRole.value());
            }
        }
        if ((withRoles = method.getAnnotation(WithRoles.class)) == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (WithRole role : withRoles.roles()) {
            result.add(role.value());
        }
        return result;
    }

    public List<String> additionalRoles(Object target) {
        if (target.getClass().getAnnotation(Secured.class) != null) {
            return Arrays.asList(target.getClass().getAnnotation(Secured.class).roles());
        }
        return Collections.emptyList();
    }
}

