/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.utils;

import de.taimos.totp.TOTP;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.AuthenticationService;
import systems.dennis.auth.client.utils.TokenProviderClient;
import systems.dennis.auth.exception.SubscriptionNotExistsException;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.responses.Auth2FactorEnabled;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.UserAssignableEntity;

@Service
@Primary
public class SecurityUtils
implements ISecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    @Autowired
    private TokenProviderClient provider;
    @Autowired
    private AuthenticationService service;
    @Autowired
    HttpServletRequest request;

    private SecurityUtils() {
    }

    public static String mask(String token) {
        if (token == null || token.length() < 2) {
            return "***********";
        }
        String stars = "*".repeat(token.length() / 2);
        return stars + token.substring(stars.length());
    }

    public boolean isAdmin() {
        try {
            List auth = this.get().getRoleList();
            for (UserRole role : auth) {
                if (!role.getRole().equals("ROLE_ADMIN")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean hasRole(String role) {
        return this.service.hasRole(role);
    }

    public String getUserLanguage() {
        return this.get().getUserData().getPreferredLanguage();
    }

    public void removeLocalAuthorization() {
        this.service.logout();
    }

    public UserTokenDTO get() throws AuthorizationNotFoundException {
        return this.tokenFromHeader();
    }

    public Long getUserDataId() {
        return this.get().getUserData().getId();
    }

    public void assignUser(DefaultForm pojo) {
        if (pojo instanceof UserAssignableEntity) {
            ((UserAssignableEntity)pojo).setUserDataId(this.get().getUserData().getId());
        }
    }

    public void checkSubscription(List<String> possibleSubscriptions) {
        List purchases = this.get().getUserData().getPurchases();
        if (purchases == null || purchases.isEmpty()) {
            throw new SubscriptionNotExistsException();
        }
        for (String purchase : purchases) {
            if (!possibleSubscriptions.contains(purchase)) continue;
            return;
        }
        throw new SubscriptionNotExistsException();
    }

    public void assignUser(DefaultForm pojo, DefaultForm originalPojo) {
        if (pojo instanceof UserAssignableEntity) {
            ((UserAssignableEntity)pojo).setUserDataId(((UserAssignableEntity)originalPojo).getUserDataId());
        }
    }

    public UserTokenDTO tokenFromHeader() throws AuthorizationNotFoundException {
        return this.provider.getAuthentication(this.getTokenFromRequest());
    }

    public String generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        return base32.encodeToString(bytes);
    }

    public Auth2FactorEnabled get2factorBarCodeForUser(LoginPasswordService loginPasswordService) {
        LoginPassword login = this.getLoginData(loginPasswordService);
        String secretKey = Optional.ofNullable(login.getTwoFactorCode()).orElseGet(() -> this.generateSecretKey());
        if (login.getTwoFactorCode() == null) {
            login.setTwoFactorCode(secretKey);
            loginPasswordService.save((BaseEntity)login);
        }
        String email = login.getLogin();
        String companyName = "dennis.systems";
        String code = this.getGoogleAuthenticatorBarCode(secretKey, email, companyName);
        Auth2FactorEnabled res = new Auth2FactorEnabled();
        res.setCode(code);
        res.setEnabled(Boolean.valueOf(login.getTwoFactor() == null ? false : login.getTwoFactor()));
        return res;
    }

    public LoginPassword getLoginData(LoginPasswordService service) {
        return (LoginPassword)service.findUserByLogin(this.get().getUserData().getLogin()).orElseThrow(() -> new AuthorizationNotFoundException(""));
    }

    public String getGoogleAuthenticatorBarCode(String secretKey, String account, String issuer) {
        return "otpauth://totp/" + URLEncoder.encode(issuer + ":" + account, StandardCharsets.UTF_8).replace("+", "%20") + "?secret=" + URLEncoder.encode(secretKey, StandardCharsets.UTF_8).replace("+", "%20") + "&issuer=" + URLEncoder.encode(issuer, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public String getTOTPCode(LoginPasswordService service, String login) {
        LoginPassword user = (LoginPassword)service.findUserByLogin(login).orElseThrow(() -> new AuthorizationNotFoundException(" No such user: " + login));
        if (user.getTwoFactor() == null || !user.getTwoFactor().booleanValue()) {
            return null;
        }
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(user.getTwoFactorCode());
        String hexKey = Hex.encodeHexString((byte[])bytes);
        return TOTP.getOTP((String)hexKey);
    }

    public String getTOTPCode(LoginPassword lp) {
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(lp.getTwoFactorCode());
        String hexKey = Hex.encodeHexString((byte[])bytes);
        return TOTP.getOTP((String)hexKey);
    }

    public TokenData getTokenFromRequest() throws AuthorizationNotFoundException {
        return this.service.getToken(this.request);
    }

    public TokenData getTokenOrThrow() throws AuthorizationNotFoundException, AuthorizationNotFoundException {
        UserTokenDTO authentication = this.get();
        TokenData token = null;
        if (authentication == null) {
            token = this.getTokenFromRequest();
        }
        if (token == null) {
            if (this.get() == null) {
                throw new AuthorizationNotFoundException("NO TOKEN PROVIDED");
            }
            UserTokenDTO tokenData = this.get();
            token = new TokenData(this.get().getScope(), this.get().getToken());
            if (token == null) {
                throw new AuthorizationNotFoundException(" NO TOKEN PROVIDED");
            }
        }
        return token;
    }

    public UserData userOrThrow() throws AuthorizationNotFoundException {
        return this.get().getUserData();
    }

    public List<String> roles() throws AuthorizationNotFoundException {
        List roles = this.get().getRoleList();
        ArrayList<String> stringRoles = new ArrayList<String>();
        for (UserRole r : roles) {
            stringRoles.add(r.getRole());
        }
        return stringRoles;
    }

    public boolean roleExists(String ... roles) throws AuthorizationNotFoundException {
        for (String role : this.roles()) {
            for (String r : roles) {
                if (!r.equalsIgnoreCase(role)) continue;
                return true;
            }
        }
        return false;
    }

    public void roleExistsOrThrow(String ... roles) throws AuthorizationNotFoundException {
        if (!this.roleExists(roles)) {
            throw new AccessDeniedException("User has not required roles " + Arrays.toString(roles));
        }
    }

    public boolean anyRole() {
        return !this.roles().isEmpty();
    }

    public void isMe(Long id) {
        boolean isMe;
        boolean bl = isMe = this.getUserDataId().equals(id) || this.isAdmin();
        if (!isMe) {
            throw new AccessDeniedException("You cannot change this object");
        }
    }

    public TokenData getToken() {
        return this.getTokenFromRequest();
    }

    public void isMy(Object item) {
        if (this.isAdmin()) {
            return;
        }
        if (!(item instanceof UserAssignableEntity)) {
            return;
        }
        UserAssignableEntity entity = (UserAssignableEntity)item;
        if (entity.getUserDataId() != null && !entity.getUserDataId().equals(this.get().getUserId())) {
            throw new AccessDeniedException("You have no access to this object");
        }
    }

    public void isMePswrd(Long id, WebContext.LocalWebContext context) {
        if (id == null) {
            return;
        }
        LoginPasswordRepo loginPasswordRepo = (LoginPasswordRepo)context.getBean(LoginPasswordRepo.class);
        UserDataRepository userDataRepository = (UserDataRepository)context.getBean(UserDataRepository.class);
        LoginPassword item = (LoginPassword)loginPasswordRepo.findById((Object)id).orElseThrow(() -> new ItemNotFoundException(id));
        UserData userData = (UserData)userDataRepository.findByLogin(item.getLogin()).orElseThrow(() -> new ItemNotFoundException(id));
        this.isMe(userData.getId());
    }
}

