/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.ScopeException;
import systems.dennis.auth.exception.TokenExpiredException;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.utils.ApplicationContext;

@Service
public class TokenProviderClient
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(TokenProviderClient.class);

    public TokenProviderClient(WebContext context) {
        super(context);
    }

    public UserTokenDTO validateToken(TokenData token) {
        UserTokenDTO dto = new UserTokenDTO();
        dto.setToken(token.getToken());
        dto.setScope(token.getScope());
        return this.validateToken(dto);
    }

    public UserTokenDTO validateToken(UserTokenDTO dto) {
        try {
            Jws claimsJws = Jwts.parser().setSigningKey(this.getSecretKey(dto.getScope()).getBytes()).parseClaimsJws(dto.getToken().replace("Bearer ", ""));
            List roles = (List)((Claims)claimsJws.getBody()).get((Object)"groups");
            Date due = ((Claims)claimsJws.getBody()).getExpiration();
            if (due.getTime() < new Date().getTime()) {
                throw new TokenExpiredException(dto.getToken());
            }
            dto.setRoleListFromGD(roles);
            dto.setDue(due);
            return dto;
        }
        catch (MalformedJwtException | SecurityException e) {
            log.info("Invalid JWT signature.");
            log.trace("Invalid JWT signature trace: {0}", e);
        }
        catch (ExpiredJwtException e) {
            log.info("Expired JWT token.");
            log.trace("Expired JWT token trace: {0}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            log.info("Unsupported JWT token.");
            log.trace("Unsupported JWT token trace: {0}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.info("JWT token compact of handler are invalid.");
            log.trace("JWT token compact of handler are invalid trace: {0}", (Throwable)e);
        }
        return null;
    }

    public UserTokenDTO getAuthentication(TokenData tokenData) {
        String token = tokenData.getToken();
        if (token == null || token.trim().isEmpty() || token.equals("null")) {
            return null;
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.getSecretKey(tokenData.getScope()).getBytes()).parseClaimsJws(token).getBody();
        UserTokenDTO dto = new UserTokenDTO();
        dto.setDue(claims.getExpiration());
        dto.setRoleListFromGD((List)claims.get((Object)"groups"));
        dto.setToken(token);
        dto.setScope(dto.getScope());
        UserData userData = new UserData();
        userData.setLogin(claims.getSubject());
        userData.setId(Long.valueOf(String.valueOf(claims.get((Object)"user_id"))));
        userData.setEmail(String.valueOf(claims.get((Object)"email")));
        userData.setLogin(String.valueOf(claims.get((Object)"bid")));
        userData.setPurchases((List)claims.get((Object)"prchs"));
        dto.setUserData(userData);
        return dto;
    }

    public String getSecretKey(String scope) {
        try {
            Object res = this.getContext().getEnv("dennis.systems.security.secret_" + scope);
            if (res == null) {
                throw new RuntimeException();
            }
            return String.valueOf(res);
        }
        catch (Exception e) {
            throw new ScopeException((Serializable)((Object)scope), "global.scope.not_supported");
        }
    }
}

