/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.client.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.utils.RoleValidationType;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.client.utils.TokenProviderClient;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.role_validator.exception.RolesNotFoundForTokenException;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;

@Service
public class TokenValidator {
    private static final Logger log = LoggerFactory.getLogger(TokenValidator.class);
    private final TokenProviderClient tokenProvider;
    private final SecurityUtils utils;

    public TokenValidator(TokenProviderClient tokenValidator, SecurityUtils utils) {
        this.tokenProvider = tokenValidator;
        this.utils = utils;
    }

    public void validate(HttpServletRequest request, List<String> roles, RoleValidationType validationType) throws AuthorizationNotFoundException, RolesNotFoundForTokenException {
        log.info("----- auth client started ------");
        if (request.getHeader("Authorization") == null && this.utils.get() == null) {
            throw new AuthorizationNotFoundException("No token, expected to have token");
        }
        if (roles != null && roles.isEmpty()) {
            return;
        }
        TokenData token = this.utils.getTokenFromRequest();
        UserTokenDTO dto = this.tokenProvider.validateToken(token);
        if (dto == null) {
            throw new AuthorizationFailedException("Invalid token");
        }
        StringBuilder buffer = new StringBuilder();
        boolean foundOne = false;
        if (roles == null) {
            return;
        }
        for (String role : roles) {
            if (role.equalsIgnoreCase("ROLE_ANY")) continue;
            boolean foundAll = false;
            for (UserRole userRole : dto.getRoleList()) {
                if (!role.equalsIgnoreCase(userRole.getRole())) continue;
                if (validationType == RoleValidationType.ONE) {
                    foundOne = true;
                }
                foundAll = true;
                break;
            }
            if (foundAll) continue;
            buffer.append("Role ").append(role).append(" not assigned to user");
        }
        if (buffer.length() > 0 && validationType == RoleValidationType.ALL || !foundOne && validationType == RoleValidationType.ONE) {
            throw new RolesNotFoundForTokenException(buffer.toString());
        }
    }

    public List<String> getValidGroups(List<String> roles) {
        TokenData token = this.utils.getTokenFromRequest();
        UserTokenDTO dto = this.tokenProvider.validateToken(token);
        List<String> validGroups = new ArrayList<String>();
        if (dto != null && dto.getRoleList() != null) {
            validGroups = dto.getRoleList().stream().map(UserRole::getRole).collect(Collectors.toList());
            if (dto.getRoleList() != null && roles != null) {
                validGroups.retainAll(roles);
            } else {
                validGroups.clear();
            }
        }
        if (roles != null && validGroups.size() == 0) {
            StringBuffer buffer = new StringBuffer();
            roles.forEach(role -> buffer.append("Role ").append((String)role).append(" not found "));
            log.warn(buffer.toString());
        }
        return validGroups;
    }
}

