/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.repository.UserInScopeRepo;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.beans.OnAppStart;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.ScopeRepo;
import systems.dennis.shared.service.ScopeService;

@Component
@Order(value=0)
public class OnAppStartImpl
implements OnAppStart {
    private static final Logger log = LoggerFactory.getLogger(OnAppStartImpl.class);

    public void onAppRun(WebContext context) {
        ScopeRepo scopeService;
        if (((LoginPasswordRepo)context.getBean(LoginPasswordRepo.class)).count() == 0L) {
            UserData data = new UserData();
            data.setLogin("admin");
            data.setEmail("admin");
            data.setName("admin");
            data.setBlocked(Boolean.valueOf(false));
            data.setVerified(Boolean.valueOf(true));
            ((UserDataRepository)context.getBean(UserDataRepository.class)).save((Object)data);
            try {
                LoginPassword lp = new LoginPassword();
                lp.setLogin(data.getLogin());
                lp.setPassword(((PasswordService)context.getBean(PasswordService.class)).toPassword(data.getLogin()));
                lp.setTwoFactor(Boolean.valueOf(false));
                ((LoginPasswordRepo)context.getBean(LoginPasswordRepo.class)).save((Object)lp);
            }
            catch (Exception e) {
                log.info(e.getMessage() + " CANNOT SAVE LP");
            }
        }
        if ((scopeService = (ScopeRepo)context.getBean(ScopeRepo.class)).count() == 0L) {
            UserData user = (UserData)((ProfilePageService)context.getBean(ProfilePageService.class)).findByLogin("admin").get();
            ScopeModel scope = new ScopeModel();
            scope.setName("Default");
            scope.setDescription("Default");
            scope.setUserDataId(user.getId());
            scope = (ScopeModel)((ScopeService)context.getBean(ScopeService.class)).save((BaseEntity)scope);
            UserInScopeModel userInScope = ((UserInScopeService)context.getBean(UserInScopeService.class)).getByUserAndScope(user, scope);
            ((UserInScopeRepo)context.getBean(UserInScopeRepo.class)).save((Object)userInScope);
        }
    }
}

