/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.AuthenticationService;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.ServerConfig;
import systems.dennis.shared.provider.ServerTypeProvider;
import systems.dennis.shared.repository.ServerConfigRepo;
import systems.dennis.shared.utils.ApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@RequestMapping(value={"api/v2/auth"})
@RestController
public class AuthorizeController
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(AuthorizeController.class);
    private final AuthenticationService userService;

    public AuthorizeController(AuthenticationService userService, WebContext context) {
        super(context);
        this.userService = userService;
    }

    @PostMapping(path={"/login"}, produces={"application/json"})
    public UserTokenDTO directLogin(@RequestBody LoginPassword password, @RequestParam(required=false) String backUrl, HttpServletRequest httpServletRequest) {
        Long userId = ((ProfilePageService)this.getBean(ProfilePageService.class)).findByLogin(password.getLogin()).map(BaseEntity::getId).orElseThrow(() -> new ItemNotFoundException(password.getLogin()));
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(httpServletRequest, userId, false);
        return this.userService.authorize(password, scope);
    }

    @GetMapping(value={"/test"})
    public UserTokenDTO authLdap(@RequestBody LoginPassword loginPassword) {
        ServerConfig config = ((ServerConfigRepo)this.getBean(ServerConfigRepo.class)).findFirstByActiveIsTrueAndType(ServerTypeProvider.LDAP).orElse(null);
        if (config == null) {
            log.info(" NO LDAP CONFIG FOUND. return null");
            return null;
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + config.getHost() + ":" + config.getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "follow");
        env.put("java.naming.security.principal", config.getUserName());
        env.put("java.naming.security.credentials", config.getPassword());
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        AuthorizeController.getUserInfo((String)loginPassword.getLogin(), (InitialLdapContext)ctx, (SearchControls)AuthorizeController.getSearchControls(), (ServerConfig)config);
        ctx.close();
        return null;
    }

    private static UserData getUserInfo(String userName, InitialLdapContext ctx, SearchControls searchControls, ServerConfig config) {
        System.out.println("*** " + userName + " ***");
        UserData user = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(config.getServerParam(), "sAMAccountName=" + userName, searchControls);
            if (answer.hasMore()) {
                Attributes attrs = answer.next().getAttributes();
                System.out.println(attrs.get("distinguishedName"));
                System.out.println(attrs.get("givenname"));
                System.out.println(attrs.get("sn"));
                System.out.println(attrs.get("mail"));
                System.out.println(attrs.get("telephonenumber"));
                byte[] byArray = (byte[])attrs.get("thumbnailPhoto").get();
            } else {
                System.out.println("user not found.");
            }
            answer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return user;
    }

    private static SearchControls getSearchControls() {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname", "mail", "telephonenumber", "thumbnailPhoto"};
        cons.setReturningAttributes(attrIDs);
        cons.setDerefLinkFlag(true);
        return cons;
    }

    private SearchControls getSimpleSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setTimeLimit(13000);
        searchControls.setCountLimit(100L);
        return searchControls;
    }

    @PostMapping(path={"/authorize_virtual_user"}, produces={"application/json"})
    public UserTokenDTO virtualLogin(@RequestBody LoginPassword password) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(this.getContext().getRequest(), this.getCurrentUser(), true);
        return this.userService.authorizeVirtual(password, scope);
    }

    @PostMapping(path={"/restore/{login}"}, produces={"text/html"})
    public String restore(@PathVariable(value="login") String login) {
        return this.userService.restore(login, this.getContext());
    }
}

