/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.config.AuthorizationDelegator;
import systems.dennis.auth.config.AuthorizeResponse;
import systems.dennis.auth.delegations.ldap.LdapAuthorization;
import systems.dennis.auth.delegations.simple.DefaultAuthorizationDelegator;
import systems.dennis.auth.delegations.virtual.VirtualUserAuthorizationDelegator;
import systems.dennis.auth.exception.AuthorizationInvalidDelegator;
import systems.dennis.auth.exception.ChangePasswordException;
import systems.dennis.auth.exception.InvalidAuthenticatorCodeException;
import systems.dennis.auth.exception.LogoutException;
import systems.dennis.auth.exception.ScopeException;
import systems.dennis.auth.exception.VerificationException;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.mail.MailSender;
import systems.dennis.auth.model.VerificationTokenModel;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.responses.Auth2FactorEnabled;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.service.VerificationTokenService;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.utils.ApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v3/auth"})
public class AuthorizeControllerVersion2
extends ApplicationContext {
    private static final Map<String, AuthorizationDelegator> delegatorMap = new HashMap();

    public AuthorizeControllerVersion2(WebContext context) {
        super(context);
    }

    public static void registerAuthorizationDelegator(String name, AuthorizationDelegator delegator) {
        delegatorMap.put(name, delegator);
    }

    @PostMapping(value={"/login"})
    public AuthorizeResponse login(HttpServletRequest req, @RequestBody LoginPassword loginPassword) {
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            return delegator.authorize(req, loginPassword, this.getContext());
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @PostMapping(value={"/register"}, produces={"application/json"}, consumes={"application/json"})
    public Boolean register(HttpServletRequest req, @RequestBody RegistrationForm loginPassword, @RequestParam(required=false) Long invitationId) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(req, null, true);
        ((AuthScopeService)this.getBean(AuthScopeService.class)).checkRegistrationAllowed(scope);
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            return delegator.register(loginPassword, this.getContext(), scope, invitationId);
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @WithRole(value="ROLE_ADMIN")
    @PostMapping(value={"/block/{user}"})
    public boolean blockUser(HttpServletRequest req, @PathVariable(value="user") Long user) {
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            return delegator.blockUser(true, user, this.getContext());
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @GetMapping(value={"/2factCode"})
    public Auth2FactorEnabled get2FactCode() {
        SecurityUtils utils = (SecurityUtils)this.getBean(SecurityUtils.class);
        return utils.get2factorBarCodeForUser((LoginPasswordService)this.getBean(LoginPasswordService.class));
    }

    @PostMapping(value={"/2factCode"})
    public Auth2FactorEnabled set2FactEnabled(@RequestBody Auth2FactorEnabled request) {
        String code;
        SecurityUtils utils = (SecurityUtils)this.getBean(SecurityUtils.class);
        LoginPassword lp = (LoginPassword)((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin(utils.get().getUserData().getLogin()).orElseThrow(() -> new ItemNotFoundException(""));
        if (request.getEnabled().booleanValue() && !(code = utils.getTOTPCode(lp)).equalsIgnoreCase(request.getCode())) {
            throw new InvalidAuthenticatorCodeException("global.exceptions.invalid_code");
        }
        Auth2FactorEnabled res = new Auth2FactorEnabled();
        res.setCode(lp.getTwoFactorCode());
        res.setEnabled(request.getEnabled());
        lp.setTwoFactor(request.getEnabled());
        ((LoginPasswordService)this.getBean(LoginPasswordService.class)).getRepository().save((Object)lp);
        res.setEnabled(request.getEnabled());
        return res;
    }

    @PostMapping(value={"/logout"})
    public String logout(HttpServletRequest req) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(req, this.getCurrentUser(), false);
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            try {
                return String.valueOf(delegator.logout(((SecurityUtils)this.getBean(SecurityUtils.class)).getTokenFromRequest().getToken(), this.getContext(), scope));
            }
            catch (AuthorizationNotFoundException exception) {
                throw new LogoutException("No token on request. cannot logout");
            }
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @PostMapping(value={"/password/reset"})
    public String changePassword(HttpServletRequest req, @RequestBody ChangePasswordForm form) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(req, this.getCurrentUser(), false);
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            try {
                return String.valueOf(delegator.changePassword(req, this.getContext(), form, scope));
            }
            catch (AuthorizationNotFoundException exception) {
                throw new ChangePasswordException("global.change_password.not_possible.wrong_auth", ((SecurityUtils)this.getContext().getBean(SecurityUtils.class)).get().getUserData().getEmail());
            }
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @PostMapping(value={"/password/forgot/{login}"})
    public void forgot(@PathVariable(value="login") String login) {
        UserData userData = (UserData)((ProfilePageService)this.getContext().getBean(ProfilePageService.class)).findByLogin(login).orElseThrow(() -> new ItemNotFoundException(login));
        VerificationTokenModel verificationToken = ((VerificationTokenService)this.getBean(VerificationTokenService.class)).saveToken(userData, 30);
        this.generateForgotAndSendForgotMessage(userData, verificationToken);
    }

    @PostMapping(value={"/password/send_temporary"})
    public String resetPassword(HttpServletRequest req, @RequestParam(value="login") String login, @RequestParam(value="token") String token) {
        ((VerificationTokenService)this.getBean(VerificationTokenService.class)).validateVerificationToken(token);
        for (AuthorizationDelegator delegator : delegatorMap.values()) {
            if (!delegator.shouldAuthorize(req, this.getContext())) continue;
            try {
                String restore = String.valueOf(delegator.forgetPassword(req, this.getContext(), login));
                ((VerificationTokenService)this.getBean(VerificationTokenService.class)).deleteToken(token);
                return restore;
            }
            catch (AuthorizationNotFoundException exception) {
                throw new LogoutException("No token on request. cannot logout");
            }
        }
        throw new AuthorizationInvalidDelegator("auth type not supported : " + req.getHeader("AUTH_TYPE") + " supported types: " + Arrays.toString(delegatorMap.keySet().toArray()));
    }

    @PostMapping(value={"/verification/verify_scope"})
    public Boolean verify(@RequestParam(value="token") String token, @RequestParam(value="scope") String scopeName) {
        ((VerificationTokenService)this.getBean(VerificationTokenService.class)).validateVerificationToken(token);
        VerificationTokenModel tokenModel = ((VerificationTokenService)this.getBean(VerificationTokenService.class)).getByToken(token);
        UserData userData = tokenModel.getUserData();
        if (Objects.nonNull(userData.getVerified()) && userData.getVerified().booleanValue()) {
            throw new VerificationException("global.exceptions.user_already_verified");
        }
        userData.setVerified(Boolean.valueOf(true));
        ((UserDataRepository)this.getBean(UserDataRepository.class)).save((Object)userData);
        tokenModel.setExpirationDate(new Date());
        ((VerificationTokenService)this.getBean(VerificationTokenService.class)).save((BaseEntity)tokenModel);
        return true;
    }

    @PostMapping(value={"/verification/resend"})
    public Boolean resendVerification(@RequestParam(value="email") String email, @RequestParam(value="scope") String scopeName) {
        UserData userData = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByLogin(email).orElseThrow(() -> new ItemNotFoundException(email));
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).findByName(scopeName, userData.getId(), false);
        if (!((UserInScopeService)this.getBean(UserInScopeService.class)).isRelationExist(userData, scope)) {
            throw new ScopeException("global.exception.user_not_in_scope");
        }
        ((VerificationTokenService)this.getBean(VerificationTokenService.class)).deleteActiveTokens(userData);
        ((UserInScopeService)this.getBean(UserInScopeService.class)).sendVerificationEmail(scope, userData);
        return true;
    }

    private void generateForgotAndSendForgotMessage(UserData userData, VerificationTokenModel verificationToken) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(this.getContext().getRequest(), userData.getId(), false);
        String url = scope.getUrl() + this.getPasswordForgotPath() + "?login=" + userData.getLogin() + "&token=" + verificationToken.getToken();
        String path = userData.getPreferredLanguage() + "/forgot_password.html";
        HashMap<String, CallSite> templateParameters = new HashMap<String, CallSite>();
        templateParameters.put("passwordLink", (CallSite)((Object)url));
        String content = ((MailSender)this.getBean(MailSender.class)).processHtmlTemplate(path, templateParameters);
        String title = this.getContext().getMessageTranslation("email.forgot_password.title", userData.getPreferredLanguage());
        ((MailSender)this.getBean(MailSender.class)).sendMail(Collections.singletonList(userData.getEmail()), content, title);
    }

    private String getBaseUrl() {
        return (String)this.getContext().getEnv("app.settings.site.self.ui");
    }

    private String getPasswordForgotPath() {
        return (String)this.getContext().getEnv("app.password.reset.path", (Object)"/forgot_password");
    }

    static {
        AuthorizeControllerVersion2.registerAuthorizationDelegator((String)"DEFAULT", (AuthorizationDelegator)new DefaultAuthorizationDelegator());
        AuthorizeControllerVersion2.registerAuthorizationDelegator((String)"VIRTUAL", (AuthorizationDelegator)new VirtualUserAuthorizationDelegator());
        AuthorizeControllerVersion2.registerAuthorizationDelegator((String)"LDAP", (AuthorizationDelegator)new LdapAuthorization());
    }
}

