/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.InvitationException;
import systems.dennis.auth.form.InvitationForm;
import systems.dennis.auth.model.InvitationModel;
import systems.dennis.auth.repository.InvitationRepo;
import systems.dennis.auth.service.InvitationService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.ListSelfItemsController;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/auth/invitation"})
@WebFormsSupport(value=InvitationService.class)
@CrossOrigin
public class InvitationController
extends ApplicationContext
implements AddItemController<InvitationModel, InvitationForm>,
ListSelfItemsController<InvitationModel, InvitationForm>,
DeleteItemController {
    public InvitationController(WebContext context) {
        super(context);
    }

    @PostMapping(value={"/accept/{id}"})
    public Boolean accept(@PathVariable(value="id") Long invitationId) {
        InvitationModel invitation = (InvitationModel)this.getService().findByIdOrThrow(invitationId);
        Boolean accepted = this.getService().accept(invitation);
        this.getService().addUserToScope(invitation);
        return accepted;
    }

    @GetMapping(value={"/my_accepted"})
    @WithRole
    public List<InvitationForm> getMyInvitation(@RequestParam(value="from", required=false) Long from, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        List models = this.getService().getMyAcceptInvitation(from, limit, page);
        ArrayList<InvitationForm> result = new ArrayList<InvitationForm>();
        for (InvitationModel model : models) {
            result.add((InvitationForm)this.toForm((BaseEntity)model));
        }
        return result;
    }

    @GetMapping(value={"/info"})
    public InvitationForm getInfo(@RequestParam(value="id") Long id) {
        InvitationModel invitation = (InvitationModel)this.getService().findByIdOrThrow(id);
        if (invitation.getAccepted().booleanValue()) {
            throw new InvitationException("global.exceptions.invitation_already_accept");
        }
        return (InvitationForm)this.toForm((BaseEntity)invitation);
    }

    @WithRole(value="ROLE_SYNC")
    @GetMapping(value={"/user/{userId}"})
    public InvitationForm getByUser(@PathVariable(value="userId") Long userId) {
        UserData user = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByIdOrThrow(userId);
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"email", (Object)user.getEmail()).specification().addCase(QueryCase.equalsOf((String)"accepted", (Object)true));
        InvitationModel model = (InvitationModel)((InvitationRepo)this.getBean(InvitationRepo.class)).findFirst((Specification)specification).orElseThrow(() -> new ItemNotFoundException(user.getEmail()));
        return (InvitationForm)this.toForm((BaseEntity)model);
    }

    public InvitationService getService() {
        return (InvitationService)this.getBean(InvitationService.class);
    }
}

