/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.service.LoginPasswordService;

@RestController
@RequestMapping(value={"/api/v2/users"})
public class RemoteUserController {
    private final LoginPasswordService service;

    public RemoteUserController(LoginPasswordService service) {
        this.service = service;
    }

    @GetMapping(value={"/search"})
    public List<String> search(@RequestParam(required=false, value="term") String text) {
        return this.service.findUsersByLogin(text);
    }

    @GetMapping(value={"/user_role/{login}/{roleId}"})
    public RolesToUser getUserAssigment(@PathVariable String login, @PathVariable Long roleId) {
        RolesToUser item = this.service.findUserAssigment(login, roleId).orElse(null);
        if (item == null) {
            return item;
        }
        item.setPassword(null);
        return item;
    }

    @PostMapping(value={"/insert/{roleId}/{userLogin}"})
    public RolesToUser insert(@PathVariable String userLogin, @PathVariable Long roleId) {
        return this.service.assignUser(userLogin, roleId);
    }
}

