/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.form.RoleForm;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"api/v2/auth/roles"})
@Secured(roles={"ROLE_ADMIN"})
@CrossOrigin
@WebFormsSupport(value=RoleServiceImpl.class)
public class RoleController
extends ApplicationContext
implements Serviceable,
DeleteItemController,
AddItemController<UserRole, RoleForm>,
EditItemController<UserRole, RoleForm>,
ListItemController<UserRole, RoleForm> {
    public RoleController(WebContext context) {
        super(context);
    }

    @DeleteMapping(value={"/deassign/{roleId}/{login}"})
    public Boolean deAssign(@PathVariable Long roleId, @PathVariable String login) {
        RoleServiceImpl service = (RoleServiceImpl)this.getService();
        return service.deAssignRole(roleId, login);
    }

    @PostMapping(value={"/assign/{roleId}/{login}"})
    public Boolean assign(@PathVariable Long roleId, @PathVariable String login) {
        RoleServiceImpl service = (RoleServiceImpl)this.getService();
        return service.assignRole(roleId, login);
    }

    static {
        SearchEntityApi.registerSearch((String)"role", (SearcherInfo)new SearcherInfo("role", RoleServiceImpl.class));
    }
}

