/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.entity.Subscription;
import systems.dennis.auth.form.SubscriptionForm;
import systems.dennis.auth.service.SubscriptionService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/auth/subscriptions"})
@Secured(roles={"ROLE_ADMIN"})
@CrossOrigin
@WebFormsSupport(value=SubscriptionService.class)
public class SubscriptionDataController
extends ApplicationContext
implements Serviceable,
DeleteItemController,
AddItemController<Subscription, SubscriptionForm>,
EditItemController<Subscription, SubscriptionForm>,
ListItemController<Subscription, SubscriptionForm> {
    public SubscriptionDataController(WebContext context) {
        super(context);
    }

    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<SubscriptionForm> edit(SubscriptionForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)form);
    }

    @WithRole(value="ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        super.delete(id);
    }
}

