/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.utils.TokenProviderClient;
import systems.dennis.auth.client.utils.TokenValidator;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;

@RestController
@RequestMapping(value={"api/v2/auth"})
@CrossOrigin(origins={"*"})
public class TokenProviderController {
    private final TokenProviderClient tokenProvider;
    private TokenValidator validator;
    private HttpServletRequest request;

    public TokenProviderController(TokenProviderClient tokenProvider, TokenValidator validator, HttpServletRequest request) {
        this.tokenProvider = tokenProvider;
        this.validator = validator;
        this.request = request;
    }

    @GetMapping(value={"/validate/{token}"})
    public ResponseEntity<UserTokenDTO> validateToken(@PathVariable(value="token") String token) {
        UserTokenDTO dto = new UserTokenDTO();
        dto.setToken(token);
        return ResponseEntity.ok((Object)this.tokenProvider.validateToken(dto));
    }

    @GetMapping(value={"/hasAnyRoleFrom"})
    public ResponseEntity<List<String>> getValidRoles(@RequestParam(value="roles") List<String> roles) {
        List validGroups = this.validator.getValidGroups(roles);
        return ResponseEntity.ok((Object)validGroups);
    }
}

