/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.entity.UserDataForm;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.provider.UserStatusProvider;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.validators.UserDataChecker;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.TransformException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.ScopeRuleModel;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@CrossOrigin(value={"*"})
@Secured
@RequestMapping(value={"/api/v2/auth/profile"})
@WebFormsSupport(value=ProfilePageService.class)
public class UserDataProfileController
extends ApplicationContext
implements EditItemController<UserData, UserDataForm> {
    public UserDataProfileController(WebContext context) {
        super(context);
    }

    @PostMapping(value={"/update/photo/{id}"})
    @WithRole
    public UserData create(@RequestParam(value="url") String url, @PathVariable(value="id") Long profileId) {
        return ((ProfilePageService)this.getBean(ProfilePageService.class)).savePhoto(profileId, url);
    }

    @WithRole(value="ROLE_SYNC")
    @GetMapping(value={"/all/scope/{name}"})
    public List<UserDataForm> findByScope(@PathVariable(value="name") String scopeName, @RequestParam(value="time", required=false) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS") String time) {
        BeanCopier copier = (BeanCopier)this.getContext().getBean(BeanCopier.class);
        ScopeModel scope = ((ScopeService)this.getBean(ScopeService.class)).findByName(scopeName, this.getCurrentUser(), true);
        MagicRequest request = new MagicRequest();
        request.getCases().add(QueryCase.equalsOf((String)"scope", (Object)scope));
        if (Objects.nonNull(time)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                Date parseTime = dateFormat.parse(time);
                request.getCases().add(QueryCase.more((String)"lastUpdate", (Object)parseTime).complex("user"));
            }
            catch (Exception e) {
                throw new TransformException("global.exception.parsing_date");
            }
        }
        List res = ((UserInScopeService)this.getBean(UserInScopeService.class)).search(request).getContent().stream().map(UserInScopeModel::getUser).collect(Collectors.toList());
        ArrayList<UserDataForm> result = new ArrayList<UserDataForm>();
        for (UserData data : res) {
            UserDataForm element = (UserDataForm)copier.copy((Object)data, UserDataForm.class);
            element.setHiddenBySystem(((ProfilePageService)this.getBean(ProfilePageService.class)).isObjectDeleted((BaseEntity)data));
            result.add(element);
        }
        return result;
    }

    @GetMapping(value={"/status/{mail}"})
    public Long getUserStatus(@PathVariable(value="mail") String mail) {
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(this.getContext().getRequest(), null, true);
        ScopeRuleModel scopeRule = scope.getScopeRule();
        Optional userData = ((ProfilePageService)this.getBean(ProfilePageService.class)).findByEmail(mail);
        if (userData.isEmpty()) {
            return UserStatusProvider.NOT_REGISTERED;
        }
        if (Objects.nonNull(((UserData)userData.get()).getVerified()) && ((UserData)userData.get()).getVerified().booleanValue()) {
            return UserStatusProvider.REGISTERED_AND_VERIFIED;
        }
        if (Objects.nonNull(scopeRule) && Objects.nonNull(scopeRule.getVerificationRequired()) && !scopeRule.getVerificationRequired().booleanValue()) {
            return UserStatusProvider.REGISTERED_NO_VERIFICATION_REQUIRED;
        }
        return UserStatusProvider.REGISTERED_NOT_VERIFIED;
    }

    @GetMapping(value={"/email/{mail}"})
    public UserDataForm getUserByEmail(@PathVariable(value="mail") String mail) {
        UserData user = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByEmail(mail).orElseThrow(() -> new ItemNotFoundException(mail));
        return (UserDataForm)this.toForm((BaseEntity)user);
    }

    @WithRole
    @PostMapping(value={"/update_lang/{lang}"})
    public ResponseEntity changeLang(@PathVariable(value="lang") String lang) {
        UserData user = (UserData)((UserDataRepository)this.getBean(UserDataRepository.class)).findById((Object)this.getCurrentUser()).orElseThrow(() -> new ItemNotFoundException("Current user is not found on db"));
        user.setPreferredLanguage(lang);
        user.setLastUpdate(new Date());
        ((UserDataRepository)this.getBean(UserDataRepository.class)).save((Object)user);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    @WithRole(value="ROLE_ADMIN")
    @ResponseBody
    public void delete(@PathVariable(value="id") Long profileId) {
        try {
            LoginPasswordService passwordBean = (LoginPasswordService)this.getBean(LoginPasswordService.class);
            LoginPassword obj = (LoginPassword)passwordBean.findByIdOrThrow(profileId);
            passwordBean.delete(profileId);
            ProfilePageService profileBean = (ProfilePageService)this.getBean(ProfilePageService.class);
            UserData profile = (UserData)profileBean.findByLogin(obj.getLogin()).orElseThrow(() -> new ItemNotFoundException(obj.getLogin()));
            ((ProfilePageService)this.getBean(ProfilePageService.class)).delete(profile.getId());
        }
        catch (Exception e) {
            throw new DeleteNotPossibleException();
        }
    }

    @WithRole
    @SelfOnlyRole(userIdField="id")
    public ResponseEntity<UserDataForm> edit(@Id(checker=UserDataChecker.class) UserDataForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)form);
    }
}

