/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.delegations.ldap;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.config.AuthorizationDelegator;
import systems.dennis.auth.config.AuthorizeResponse;
import systems.dennis.auth.delegations.simple.AuthorizationAttemptProcessor;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.entity.LoginHistory;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.repository.ActiveTokensRepo;
import systems.dennis.auth.repository.LoginHistoryRepository;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.ServerConfig;
import systems.dennis.shared.provider.ServerTypeProvider;
import systems.dennis.shared.repository.ServerConfigRepo;

/*
 * Exception performing whole class analysis ignored.
 */
public class LdapAuthorization
implements AuthorizationAttemptProcessor,
AuthorizationDelegator {
    private static final Logger log = LoggerFactory.getLogger(LdapAuthorization.class);

    public <T extends UserTokenDTO> T authorize(LoginPassword loginPassword, WebContext.LocalWebContext context, ScopeModel scope) {
        ServerConfig config = ((ServerConfigRepo)context.getBean(ServerConfigRepo.class)).findFirstByActiveIsTrueAndType(ServerTypeProvider.LDAP).orElse(null);
        if (config == null) {
            log.info(" NO LDAP CONFIG FOUND. return null");
            return null;
        }
        if (loginPassword.getDomain() == null) {
            throw new AuthorizationFailedException("Domain is required for authorization");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + config.getHost() + ":" + config.getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "follow");
        env.put("java.naming.security.principal", loginPassword.getDomain() + "\\" + loginPassword.getLogin());
        env.put("java.naming.security.credentials", loginPassword.getPassword());
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            UserData res = this.getUserInfo(loginPassword.getLogin(), ctx, LdapAuthorization.getSearchControls(), config, context);
            if (!((UserInScopeService)context.getBean(UserInScopeService.class)).isRelationExist(res, scope)) {
                throw new AuthorizationFailedException(res.getLogin());
            }
            ctx.close();
            LoginPasswordService lps = (LoginPasswordService)context.getBean(LoginPasswordService.class);
            Optional existingLoginPassword = lps.findUserByLogin(loginPassword.getLogin());
            loginPassword = existingLoginPassword.isPresent() ? (LoginPassword)existingLoginPassword.get() : (LoginPassword)lps.save((BaseEntity)loginPassword);
            UserTokenDTO dto = new UserTokenDTO();
            dto.setUserData(res);
            List roles = ((PasswordService)context.getBean(PasswordService.class)).getRoles(loginPassword, scope);
            ActiveToken token = ((TokenProvider)context.getBean(TokenProvider.class)).createToken(dto, "LDAP", roles, scope);
            dto.setToken(token.getToken());
            dto.setDue(token.getDue());
            dto.setRoles(roles);
            return (T)dto;
        }
        catch (NamingException e) {
            throw new AuthorizationFailedException(loginPassword.getLogin());
        }
    }

    private static SearchControls getSearchControls() {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname", "mail", "telephonenumber", "thumbnailPhoto"};
        cons.setReturningAttributes(attrIDs);
        cons.setDerefLinkFlag(true);
        return cons;
    }

    private UserData getUserInfo(String userName, InitialLdapContext ctx, SearchControls searchControls, ServerConfig config, WebContext.LocalWebContext context) {
        System.out.println("*** " + userName + " ***");
        UserData user = ((UserDataRepository)context.getBean(UserDataRepository.class)).findByLogin(userName).orElse(new UserData());
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(config.getServerParam(), "sAMAccountName=" + userName, searchControls);
            if (!answer.hasMore()) {
                throw new AuthorizationFailedException("User had successfully logged in, but there is no info in LDAP about user" + userName);
            }
            Attributes attrs = answer.next().getAttributes();
            user.setLogin(userName);
            user.setEmail(this.getValue(attrs.get("mail")));
            user.setName(this.getValue(attrs.get("givenname")) + " " + this.getValue(attrs.get("sn")));
            user.setPhone(this.getValue(attrs.get("telephonenumber")));
            user.setEmail(this.getValue(attrs.get("mail")));
            user = (UserData)((UserDataRepository)context.getBean(UserDataRepository.class)).save((Object)user);
            answer.close();
        }
        catch (AuthorizationFailedException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return user;
    }

    private String getValue(Attribute attribute) {
        try {
            return String.valueOf(attribute.get());
        }
        catch (Exception e) {
            return "";
        }
    }

    public <T extends UserData> T createUser(LoginPassword loginPassword, WebContext.LocalWebContext context) {
        return null;
    }

    public void saveLoginAttempt(UserTokenDTO user, WebContext.LocalWebContext context) {
        LoginHistory history = new LoginHistory();
        log.debug("TRacing Login history started");
        history.setUserDataId(context.getCurrentUser());
        history.setToken(user.getToken());
        history.setAuthorizationType("LDAP");
        history.setLogin(user.getUserData().getLogin());
        ((LoginHistoryRepository)context.getBean(LoginHistoryRepository.class)).save((Object)history);
    }

    public AuthorizeResponse authorize(HttpServletRequest request, LoginPassword password, WebContext.LocalWebContext context) {
        UserData user = (UserData)((ProfilePageService)context.getBean(ProfilePageService.class)).findByLogin(password.getLogin()).orElseThrow(() -> new ItemNotFoundException(password.getLogin()));
        ScopeModel scope = ((AuthScopeService)context.getBean(AuthScopeService.class)).getScopeFromRequest(request, user.getId(), false);
        ((ProfilePageService)context.getBean(ProfilePageService.class)).checkVerifiedUser(user, scope);
        UserTokenDTO res = this.authorize(password, context, scope);
        return AuthorizeResponse.of((UserTokenDTO)res, (boolean)false);
    }

    public boolean shouldAuthorize(HttpServletRequest request, WebContext.LocalWebContext context) {
        if ("LDAP".equals(request.getHeader("AUTH_TYPE"))) {
            log.debug("Header AUTH-TYPE declares to use VirtualUserAuth");
            return true;
        }
        log.debug("Header AUTH-TYPE declares not to use VirtualUserAuth");
        return false;
    }

    public boolean blockUser(boolean block, Long userDataId, WebContext.LocalWebContext context) {
        UserDataRepository service = (UserDataRepository)context.getBean(UserDataRepository.class);
        UserData item = (UserData)service.findById((Object)userDataId).orElseThrow(() -> new ItemNotFoundException(userDataId));
        service.save((Object)item);
        List activeTokens = ((ActiveTokensRepo)context.getBean(ActiveTokensRepo.class)).findByUserDataIdAndActiveIsTrueAndDueGreaterThan(userDataId, new Date());
        for (ActiveToken token : activeTokens) {
            this.logout(token.getToken(), context, token.getScope());
        }
        return true;
    }

    public boolean logout(String token, WebContext.LocalWebContext context, ScopeModel scope) {
        ((TokenProvider)context.getBean(TokenProvider.class)).removeAuthToken(token, "VIRTUAL", scope);
        return true;
    }

    public boolean register(RegistrationForm form, WebContext.LocalWebContext context, ScopeModel scope, Long invitationId) {
        throw new AccessDeniedException("User can not be registered in LDAP");
    }

    public void validate(UserTokenDTO dto, WebContext.LocalWebContext context) {
        dto.validate(context);
    }

    public boolean changePassword(HttpServletRequest req, WebContext.LocalWebContext context, ChangePasswordForm loginPassword, ScopeModel scope) {
        throw new AccessDeniedException("User can not be changed in LDAP");
    }

    public String forgetPassword(HttpServletRequest req, WebContext.LocalWebContext context, String login) {
        throw new AccessDeniedException("User can not restore password in LDAP");
    }
}

