/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.delegations.simple;

import jakarta.servlet.http.HttpServletRequest;
import java.rmi.AccessException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.AuthenticationService;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.config.AuthorizationDelegator;
import systems.dennis.auth.config.AuthorizeResponse;
import systems.dennis.auth.delegations.simple.SimpleTokenAuthorization;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.exception.DuplicateRelationException;
import systems.dennis.auth.exception.InvitationException;
import systems.dennis.auth.exception.UserIsBlockedException;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.model.InvitationModel;
import systems.dennis.auth.repository.ActiveTokensRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ChangePasswordServiceImpl;
import systems.dennis.auth.service.InvitationService;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.ValidateForm;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ValidationFailedException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.provider.ServerTypeProvider;
import systems.dennis.shared.repository.ServerConfigRepo;

public class DefaultAuthorizationDelegator
implements AuthorizationDelegator {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizationDelegator.class);
    public static final String AUTH_TYPE_DEFAULT = "DEFAULT";

    public AuthorizeResponse authorize(HttpServletRequest request, LoginPassword password, WebContext.LocalWebContext context) {
        UserData user = (UserData)((ProfilePageService)context.getBean(ProfilePageService.class)).findByLogin(password.getLogin()).orElseThrow(() -> new ItemNotFoundException(password.getLogin()));
        ScopeModel scope = ((AuthScopeService)context.getBean(AuthScopeService.class)).getScopeFromRequest(request, user.getId(), false);
        ((ProfilePageService)context.getBean(ProfilePageService.class)).checkVerifiedUser(user, scope);
        UserTokenDTO res = new SimpleTokenAuthorization().authorize(password, context, scope);
        if (res == null) {
            log.debug("Authorization failed. We throw authorization exception");
            this.invokeAuthError(password);
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        return AuthorizeResponse.of((UserTokenDTO)res, (boolean)false);
    }

    private void invokeAuthError(LoginPassword password) {
        throw new AuthorizationFailedException(password.getLogin());
    }

    public boolean shouldAuthorize(HttpServletRequest request, WebContext.LocalWebContext context) {
        if (request.getHeader("AUTH_TYPE") == null || AUTH_TYPE_DEFAULT.equals(request.getHeader("AUTH_SCOPE"))) {
            log.debug("Header AUTH-TYPE declares to use DefaultAuthorizationDelegator");
            if (((ServerConfigRepo)context.getBean(ServerConfigRepo.class)).findFirstByActiveIsTrueAndType(ServerTypeProvider.LDAP).isPresent()) {
                throw new AuthorizationFailedException("LDAP CONFIG is active. Default authorization is not possible");
            }
            return true;
        }
        log.debug("Header AUTH-TYPE declares not to use DefaultAuthorizationDelegator");
        return false;
    }

    public boolean blockUser(boolean block, Long userDataId, WebContext.LocalWebContext context) {
        UserDataRepository service = (UserDataRepository)context.getBean(UserDataRepository.class);
        UserData item = (UserData)service.findById((Object)userDataId).orElseThrow(() -> new ItemNotFoundException(userDataId));
        service.save((Object)item);
        List activeTokens = ((ActiveTokensRepo)context.getBean(ActiveTokensRepo.class)).findByUserDataIdAndActiveIsTrueAndDueGreaterThan(userDataId, new Date());
        for (ActiveToken token : activeTokens) {
            this.logout(token.getToken(), context, token.getScope());
        }
        return true;
    }

    public boolean logout(String token, WebContext.LocalWebContext context, ScopeModel scope) {
        SecurityContextHolder.getContext().setAuthentication(null);
        ((TokenProvider)context.getBean(TokenProvider.class)).removeAuthToken(token, AUTH_TYPE_DEFAULT, scope);
        return true;
    }

    public boolean register(RegistrationForm form, WebContext.LocalWebContext context, ScopeModel scope, Long invitationId) {
        try {
            ((ValidateForm)() -> context).validate((DefaultForm)form, false, LoginPasswordService.class);
            InvitationModel invitationModel = null;
            if (invitationId != null && invitationId > 0L) {
                invitationModel = (InvitationModel)((InvitationService)context.getBean(InvitationService.class)).findByIdOrThrow(invitationId);
                ((InvitationService)context.getBean(InvitationService.class)).accept(invitationModel);
            }
            LoginPasswordService service = (LoginPasswordService)context.getBean(LoginPasswordService.class);
            LoginPassword newLoginPassword = this.getOrSavePassword(form, context);
            UserData userData = this.getOrSaveUser(form, context);
            if (Objects.nonNull(invitationModel)) {
                ((InvitationService)context.getBean(InvitationService.class)).addUserToScope(invitationModel);
            } else {
                ((UserInScopeService)context.getBean(UserInScopeService.class)).generateAndSave(userData, scope);
                service.saveUserRoles(newLoginPassword, scope);
            }
            return true;
        }
        catch (DuplicateRelationException | InvitationException | ValidationFailedException ve) {
            throw ve;
        }
        catch (Exception x) {
            log.error("error on save user data " + form.getEmail(), (Throwable)x);
            throw new AccessException("Cannot register", x);
        }
    }

    public void validate(UserTokenDTO dto, WebContext.LocalWebContext context) {
        dto.validate(context);
        if (dto.getUserData().getBlocked() == Boolean.TRUE) {
            throw new UserIsBlockedException("User is blocked");
        }
    }

    public boolean changePassword(HttpServletRequest req, WebContext.LocalWebContext context, ChangePasswordForm loginPassword, ScopeModel scope) {
        if (!Objects.equals(loginPassword.getPassword(), loginPassword.getRepeatPassword())) {
            throw new AuthorizationFailedException("global.exceptions.incorrect_password");
        }
        LoginPassword lp = new LoginPassword();
        lp.setPassword(loginPassword.getCurrentPassword());
        lp.setLogin(((SecurityUtils)context.getBean(SecurityUtils.class)).get().getUserData().getLogin());
        lp.setTwoFactorCode(loginPassword.getTwoFactorCode());
        try {
            this.authorize(req, lp, context);
        }
        catch (Exception e) {
            throw new AuthorizationFailedException(lp.getLogin());
        }
        lp.setPassword(loginPassword.getPassword());
        ((ChangePasswordServiceImpl)context.getBean(ChangePasswordServiceImpl.class)).changePassword(lp);
        return true;
    }

    public String forgetPassword(HttpServletRequest req, WebContext.LocalWebContext context, String login) {
        return ((AuthenticationService)context.getBean(AuthenticationService.class)).restore(login, context);
    }

    private LoginPassword getOrSavePassword(RegistrationForm form, WebContext.LocalWebContext context) {
        LoginPasswordService service = (LoginPasswordService)context.getBean(LoginPasswordService.class);
        Optional loginPassword = service.findUserByLogin(form.getEmail());
        if (loginPassword.isPresent()) {
            return (LoginPassword)loginPassword.get();
        }
        LoginPassword newLoginPassword = new LoginPassword();
        newLoginPassword.setLogin(form.getEmail());
        newLoginPassword.setPassword(form.getPassword());
        return (LoginPassword)service.save((BaseEntity)newLoginPassword);
    }

    private UserData getOrSaveUser(RegistrationForm form, WebContext.LocalWebContext context) {
        Optional user = ((ProfilePageService)context.getBean(ProfilePageService.class)).findByEmail(form.getEmail());
        if (user.isPresent()) {
            return (UserData)user.get();
        }
        UserData userData = ((LoginPasswordService)context.getBean(LoginPasswordService.class)).saveUserData(form);
        ((AuthScopeService)context.getBean(AuthScopeService.class)).generateAndSaveUserScope(userData);
        return userData;
    }
}

