/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.delegations.simple;

import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.delegations.simple.AuthorizationAttemptProcessor;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.entity.LoginHistory;
import systems.dennis.auth.repository.LoginHistoryRepository;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.model.ScopeModel;

public class SimpleTokenAuthorization
implements AuthorizationAttemptProcessor {
    private static final Logger log = LoggerFactory.getLogger(SimpleTokenAuthorization.class);

    public UserTokenDTO authorize(LoginPassword password, WebContext.LocalWebContext context, ScopeModel scope) {
        PasswordService passwordService = (PasswordService)context.getBean(PasswordService.class);
        LoginPasswordService loginPasswordService = (LoginPasswordService)context.getBean(LoginPasswordService.class);
        TokenProvider tokenProvider = (TokenProvider)context.getBean(TokenProvider.class);
        LoginPassword res = null;
        password.setPassword(passwordService.toPassword(password.getPassword()));
        res = loginPasswordService.findOrThrow(password, true);
        if (res == null) {
            throw new AuthorizationFailedException(password.getLogin());
        }
        UserData userData = this.createUser(res, context);
        if (!((UserInScopeService)context.getBean(UserInScopeService.class)).isRelationExist(userData, scope)) {
            throw new AuthorizationFailedException(password.getLogin());
        }
        UserTokenDTO dto = new UserTokenDTO();
        dto.setUserData(userData);
        log.debug("Authorization ->  , creating token: {}", (Object)password.getLogin());
        List roles = passwordService.getRoles(res, scope);
        ActiveToken token = tokenProvider.createToken(dto, "DEFAULT", roles, scope);
        dto.setToken(token.getToken());
        dto.setDue(token.getDue());
        dto.setRoles(roles);
        this.saveLoginAttempt(dto, context);
        return dto;
    }

    public UserData createUser(LoginPassword loginPassword, WebContext.LocalWebContext context) {
        UserData temp = new UserData();
        temp.setLogin(loginPassword.getLogin());
        Optional user = ((UserDataRepository)context.getBean(UserDataRepository.class)).findByLogin(temp.getLogin());
        return user.orElseGet(() -> this.createUser(temp));
    }

    private UserData createUser(UserData temp) {
        UserData newUserData = new UserData();
        newUserData.setLogin(temp.getEmail());
        newUserData.setEmail(temp.getEmail());
        return newUserData;
    }

    public void saveLoginAttempt(UserTokenDTO user, WebContext.LocalWebContext context) {
        LoginHistory history = new LoginHistory();
        log.debug("TRacing Login history started");
        history.setUserDataId(user.getUserData().getId());
        history.setToken(user.getToken());
        history.setAuthorizationType("DEFAULT");
        history.setLogin(user.getUserData().getLogin());
        ((LoginHistoryRepository)context.getBean(LoginHistoryRepository.class)).save((Object)history);
    }
}

