/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.delegations.virtual;

import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.config.AuthorizationDelegator;
import systems.dennis.auth.config.AuthorizeResponse;
import systems.dennis.auth.delegations.virtual.DirectUserLoginAuthorization;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.auth.exception.UserIsBlockedException;
import systems.dennis.auth.exception.VirtualUserAuthorizationException;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.repository.VirtualLoginPasswordRepo;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.model.ScopeModel;

public class VirtualUserAuthorizationDelegator
implements AuthorizationDelegator {
    private static final Logger log = LoggerFactory.getLogger(VirtualUserAuthorizationDelegator.class);
    public static final String AUTH_TYPE_VIRTUAL = "VIRTUAL";

    public AuthorizeResponse authorize(HttpServletRequest request, LoginPassword password, WebContext.LocalWebContext context) {
        ScopeModel scope = ((AuthScopeService)context.getBean(AuthScopeService.class)).getScopeFromRequest(request, null, true);
        VirtualLoginPassword item = (VirtualLoginPassword)((VirtualLoginPasswordRepo)context.getBean(VirtualLoginPasswordRepo.class)).login(password.getLogin(), ((PasswordService)context.getBean(PasswordService.class)).toPassword(password.getPassword())).orElseThrow(() -> new AuthorizationFailedException(password.getLogin()));
        if (item.getIsActive() != null && item.getIsActive() == Boolean.FALSE) {
            throw new VirtualUserAuthorizationException("User " + password.getLogin() + " is blocked");
        }
        UserData toAuth = (UserData)((UserDataRepository)context.getBean(UserDataRepository.class)).findById((Object)item.getUserDataId()).orElseThrow(() -> new VirtualUserAuthorizationException("User assigned to virtual user does not exist"));
        if (toAuth.getBlocked() == Boolean.TRUE) {
            throw new UserIsBlockedException(" User owning this virtual user is blocked");
        }
        LoginPassword realUserLoginPassword = (LoginPassword)((LoginPasswordRepo)context.getBean(LoginPasswordRepo.class)).findByLogin(toAuth.getLogin()).orElseThrow();
        UserTokenDTO auth = new DirectUserLoginAuthorization(AUTH_TYPE_VIRTUAL).authorize(password, context, scope);
        return AuthorizeResponse.of((UserTokenDTO)auth, (boolean)false);
    }

    public boolean shouldAuthorize(HttpServletRequest request, WebContext.LocalWebContext context) {
        if (AUTH_TYPE_VIRTUAL.equals(request.getHeader("AUTH_TYPE"))) {
            log.debug("Header AUTH-TYPE declares to use VirtualUserAuth");
            return true;
        }
        log.debug("Header AUTH-TYPE declares not to use VirtualUserAuth");
        return false;
    }

    public boolean blockUser(boolean block, Long userDataId, WebContext.LocalWebContext context) {
        return true;
    }

    public boolean logout(String token, WebContext.LocalWebContext context, ScopeModel scope) {
        ((TokenProvider)context.getBean(TokenProvider.class)).removeAuthToken(token, AUTH_TYPE_VIRTUAL, scope);
        return true;
    }

    public boolean register(RegistrationForm form, WebContext.LocalWebContext context, ScopeModel scope, Long invitationId) {
        throw new AccessDeniedException("registering virtual users is not possible");
    }

    public void validate(UserTokenDTO dto, WebContext.LocalWebContext context) {
        dto.validate(context);
        if (dto.getUserData().getBlocked() == Boolean.TRUE) {
            throw new UserIsBlockedException("User is blocked");
        }
    }

    public boolean changePassword(HttpServletRequest req, WebContext.LocalWebContext context, ChangePasswordForm loginPassword, ScopeModel scope) {
        throw new AccessDeniedException("changing password of virtual users is not possible");
    }

    public String forgetPassword(HttpServletRequest req, WebContext.LocalWebContext context, String login) {
        throw new AccessDeniedException("forget password of virtual users is not possible");
    }
}

