/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ActiveToken
extends UserAssignableEntity {
    public static final String DEFAULT_TOKEN_TYPE = "DEFAULT";
    public static final String DEFAULT_LDAP_TOKEN_TYPE = "LDAP";
    public static final String DEFAULT_VIRTUAL_TYPE = "VIRTUAL";
    @Column(columnDefinition="TEXT")
    private String token;
    private Date due;
    private Boolean active = Boolean.TRUE;
    private String type = "DEFAULT";
    private Date closed;
    @ObjectByIdPresentation
    @ManyToOne
    @DataTransformer(additionalClass=AuthScopeService.class, transFormWith=IdToObjectTransformer.class)
    private ScopeModel scope;

    public String getToken() {
        return this.token;
    }

    public Date getDue() {
        return this.due;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getType() {
        return this.type;
    }

    public Date getClosed() {
        return this.closed;
    }

    public ScopeModel getScope() {
        return this.scope;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClosed(Date closed) {
        this.closed = closed;
    }

    public void setScope(ScopeModel scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveToken)) {
            return false;
        }
        ActiveToken other = (ActiveToken)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Date this$due = this.getDue();
        Date other$due = other.getDue();
        if (this$due == null ? other$due != null : !((Object)this$due).equals(other$due)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$closed = this.getClosed();
        Date other$closed = other.getClosed();
        if (this$closed == null ? other$closed != null : !((Object)this$closed).equals(other$closed)) {
            return false;
        }
        ScopeModel this$scope = this.getScope();
        ScopeModel other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActiveToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Date $due = this.getDue();
        result = result * 59 + ($due == null ? 43 : ((Object)$due).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $closed = this.getClosed();
        result = result * 59 + ($closed == null ? 43 : ((Object)$closed).hashCode());
        ScopeModel $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public String toString() {
        return "ActiveToken(token=" + this.getToken() + ", due=" + String.valueOf(this.getDue()) + ", active=" + this.getActive() + ", type=" + this.getType() + ", closed=" + String.valueOf(this.getClosed()) + ", scope=" + String.valueOf(this.getScope()) + ")";
    }
}

