/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.form;

import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.validators.UniqueRoleScopeValidator;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

@PojoListView(showId=true, enableSearching=true, actions={"download", "new", "settings"})
public class RoleForm
implements DefaultForm {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ADMIN = "admin";
    @PojoFormElement(type="hidden")
    private Long id;
    @Validation(value={ValueNotEmptyValidator.class, UniqueRoleScopeValidator.class})
    @PojoFormElement(required=true)
    @PojoListViewField(searchable=true)
    private String role;
    @PojoListViewField(searchable=true, remote=@Remote(searchType="checkbox"))
    @PojoFormElement(type="checkbox", checked=@Checkable(isCheckElement=true, checked=true))
    private Boolean autoApply;
    @PojoFormElement(type="checkbox", checked=@Checkable(isCheckElement=true, checked=true))
    @PojoListViewField(visible=false, searchable=true, remote=@Remote(searchType="checkbox"))
    private Boolean addToEveryUser;
    @PojoListViewField(searchable=true, remote=@Remote(searchType="checkbox"))
    @PojoFormElement(type="checkbox", checked=@Checkable(isCheckElement=true, checked=true))
    public Boolean autoApplyOnVirtualUser;
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=AuthScopeService.class)
    @PojoFormElement(type="object_chooser", remote=@Remote(fetcher="auth/scope", searchType="object_chooser", searchField="name", searchName="scope"))
    @PojoListViewField(type="object_chooser", searchable=true, remote=@Remote(fetcher="auth/scope", searchType="object_chooser", searchField="name", searchName="scope"))
    private Long scope;
    @PojoFormElement(visible=false, required=false)
    @PojoListViewField(searchable=false, sortable=false, showContent=false, actions={@UIAction(component="edit"), @UIAction(component="delete", allowOnMultipleRows=true)})
    private Integer action;

    public String asValue() {
        Object res = this.role;
        res = this.scope == null ? (String)res + " undefined_scope" : (String)res + " " + this.scope;
        return res;
    }

    public Long getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public Boolean getAutoApply() {
        return this.autoApply;
    }

    public Boolean getAddToEveryUser() {
        return this.addToEveryUser;
    }

    public Boolean getAutoApplyOnVirtualUser() {
        return this.autoApplyOnVirtualUser;
    }

    public Long getScope() {
        return this.scope;
    }

    public Integer getAction() {
        return this.action;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setAutoApply(Boolean autoApply) {
        this.autoApply = autoApply;
    }

    public void setAddToEveryUser(Boolean addToEveryUser) {
        this.addToEveryUser = addToEveryUser;
    }

    public void setAutoApplyOnVirtualUser(Boolean autoApplyOnVirtualUser) {
        this.autoApplyOnVirtualUser = autoApplyOnVirtualUser;
    }

    public void setScope(Long scope) {
        this.scope = scope;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleForm)) {
            return false;
        }
        RoleForm other = (RoleForm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$autoApply = this.getAutoApply();
        Boolean other$autoApply = other.getAutoApply();
        if (this$autoApply == null ? other$autoApply != null : !((Object)this$autoApply).equals(other$autoApply)) {
            return false;
        }
        Boolean this$addToEveryUser = this.getAddToEveryUser();
        Boolean other$addToEveryUser = other.getAddToEveryUser();
        if (this$addToEveryUser == null ? other$addToEveryUser != null : !((Object)this$addToEveryUser).equals(other$addToEveryUser)) {
            return false;
        }
        Boolean this$autoApplyOnVirtualUser = this.getAutoApplyOnVirtualUser();
        Boolean other$autoApplyOnVirtualUser = other.getAutoApplyOnVirtualUser();
        if (this$autoApplyOnVirtualUser == null ? other$autoApplyOnVirtualUser != null : !((Object)this$autoApplyOnVirtualUser).equals(other$autoApplyOnVirtualUser)) {
            return false;
        }
        Long this$scope = this.getScope();
        Long other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        Integer this$action = this.getAction();
        Integer other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleForm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $autoApply = this.getAutoApply();
        result = result * 59 + ($autoApply == null ? 43 : ((Object)$autoApply).hashCode());
        Boolean $addToEveryUser = this.getAddToEveryUser();
        result = result * 59 + ($addToEveryUser == null ? 43 : ((Object)$addToEveryUser).hashCode());
        Boolean $autoApplyOnVirtualUser = this.getAutoApplyOnVirtualUser();
        result = result * 59 + ($autoApplyOnVirtualUser == null ? 43 : ((Object)$autoApplyOnVirtualUser).hashCode());
        Long $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        Integer $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    public String toString() {
        return "RoleForm(id=" + this.getId() + ", role=" + this.getRole() + ", autoApply=" + this.getAutoApply() + ", addToEveryUser=" + this.getAddToEveryUser() + ", autoApplyOnVirtualUser=" + this.getAutoApplyOnVirtualUser() + ", scope=" + this.getScope() + ", action=" + this.getAction() + ")";
    }
}

