/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import systems.dennis.auth.exception.EmailSendingException;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.SimpleEvaluator;

@Component
public class MailSender
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(MailSender.class);
    private final Environment environment;

    public MailSender(WebContext context, Environment environment) {
        super(context);
        this.environment = environment;
    }

    public void sendMail(List<String> recipients, String body, String title) {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.getHost());
        properties.put("mail.smtp.port", (Object)this.getPort());
        properties.put("mail.smtp.auth", (Object)this.isAuth());
        properties.put("mail.smtp.starttls.enable", (Object)this.isStarttls());
        Session session = Session.getInstance((Properties)properties, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.getUsername()));
            ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
            for (String recipient : recipients) {
                recipientAddresses.add(new InternetAddress(recipient));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
            message.setSubject(title);
            message.setContent((Object)body, "text/html; charset=UTF-8");
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            log.error("Error sending email");
            throw new EmailSendingException((Serializable)((Object)e), "Error sending email");
        }
    }

    public String processHtmlTemplate(String path, Map<String, String> params) {
        try {
            ClassPathResource resource = new ClassPathResource("mail-templates/" + path);
            InputStream inputStream = resource.getInputStream();
            String html = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            SimpleEvaluator evaluator = new SimpleEvaluator(this.environment);
            return evaluator.evaluate(html, 0, params);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process HTML template: " + path, e);
        }
    }

    private String getHost() {
        return (String)this.getContext().getEnv("app.auth.mail.host");
    }

    private int getPort() {
        return (Integer)this.getContext().getEnv("app.auth.mail.port");
    }

    private String getUsername() {
        return (String)this.getContext().getEnv("app.auth.mail.username");
    }

    private String getPassword() {
        return (String)this.getContext().getEnv("app.auth.mail.password");
    }

    private boolean isAuth() {
        return (Boolean)this.getContext().getEnv("app.auth.mail.properties.mail.smtp.auth");
    }

    private boolean isStarttls() {
        return (Boolean)this.getContext().getEnv("app.auth.mail.properties.mail.smtp.starttls.enable");
    }
}

