/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.model;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class InvitationModel
extends UserAssignableEntity {
    private String name;
    private String email;
    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProfilePageService.class)
    private UserData inviter;
    private Boolean accepted;
    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(additionalClass=AuthScopeService.class, transFormWith=IdToObjectTransformer.class)
    private ScopeModel scope;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date date;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date dateDue;

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public UserData getInviter() {
        return this.inviter;
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public ScopeModel getScope() {
        return this.scope;
    }

    public Date getDate() {
        return this.date;
    }

    public Date getDateDue() {
        return this.dateDue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setInviter(UserData inviter) {
        this.inviter = inviter;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public void setScope(ScopeModel scope) {
        this.scope = scope;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvitationModel)) {
            return false;
        }
        InvitationModel other = (InvitationModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$accepted = this.getAccepted();
        Boolean other$accepted = other.getAccepted();
        if (this$accepted == null ? other$accepted != null : !((Object)this$accepted).equals(other$accepted)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        UserData this$inviter = this.getInviter();
        UserData other$inviter = other.getInviter();
        if (this$inviter == null ? other$inviter != null : !this$inviter.equals(other$inviter)) {
            return false;
        }
        ScopeModel this$scope = this.getScope();
        ScopeModel other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Date this$dateDue = this.getDateDue();
        Date other$dateDue = other.getDateDue();
        return !(this$dateDue == null ? other$dateDue != null : !((Object)this$dateDue).equals(other$dateDue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvitationModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $accepted = this.getAccepted();
        result = result * 59 + ($accepted == null ? 43 : ((Object)$accepted).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        UserData $inviter = this.getInviter();
        result = result * 59 + ($inviter == null ? 43 : $inviter.hashCode());
        ScopeModel $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Date $dateDue = this.getDateDue();
        result = result * 59 + ($dateDue == null ? 43 : ((Object)$dateDue).hashCode());
        return result;
    }

    public String toString() {
        return "InvitationModel(name=" + this.getName() + ", email=" + this.getEmail() + ", inviter=" + String.valueOf(this.getInviter()) + ", accepted=" + this.getAccepted() + ", scope=" + String.valueOf(this.getScope()) + ", date=" + String.valueOf(this.getDate()) + ", dateDue=" + String.valueOf(this.getDateDue()) + ")";
    }
}

