/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.role_validator;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.entity.Purchase;
import systems.dennis.auth.entity.Subscription;
import systems.dennis.auth.exception.LogoutException;
import systems.dennis.auth.repository.ActiveTokensRepo;
import systems.dennis.auth.repository.PurchaseRepo;
import systems.dennis.auth.repository.SubscriptionRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.UserSettingService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.utils.ApplicationContext;

@Component
public class TokenProvider
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    public static final String AUTHORITIES_KEY = "groups";
    public static final String USER_ID = "user_id";
    public static final String USER_EMAIL = "email";
    public static final String USER_LOGIN = "bid";
    public static final String USER_INNER_NUMBER = "userDataId";
    public static final String ISSUER = "usb";
    public static final String PURCHASES = "prchs";
    public static final String LANG = "lang";
    final UserDataRepository userRepository;
    final PurchaseRepo purchaseRepo;
    final SubscriptionRepo subscriptionRepo;

    public TokenProvider(WebContext context, UserDataRepository userRepository, PurchaseRepo repo, SubscriptionRepo subscriptionRepo) {
        super(context);
        this.userRepository = userRepository;
        this.purchaseRepo = repo;
        this.subscriptionRepo = subscriptionRepo;
    }

    public ActiveToken createToken(UserTokenDTO dto, String tokenType, List<UserRole> roleList, ScopeModel scope) {
        ActiveTokensRepo repo = (ActiveTokensRepo)this.getBean(ActiveTokensRepo.class);
        ActiveToken current = repo.findFirstByUserDataIdAndActiveIsTrueAndDueGreaterThanAndTypeAndScope(dto.getUserId(), new Date(), tokenType, scope).orElse(null);
        if (current != null) {
            return current;
        }
        Calendar validity = Calendar.getInstance();
        validity.setTime(new Date());
        validity.add(12, this.getTokenValidity(scope));
        dto.setDue(validity.getTime());
        log.debug("We start Jwts Building...   {}, \n --> roles \n {} ", (Object)dto.getUserData(), roleList);
        List purchases = this.findPurchases(dto);
        dto.getUserData().setPurchases(purchases);
        String token = Jwts.builder().setSubject(dto.getUserData().getEmail()).setIssuer(ISSUER).claim(AUTHORITIES_KEY, roleList.stream().map(UserRole::getRole).collect(Collectors.toList())).claim(USER_ID, (Object)dto.getUserData().getId()).claim(USER_EMAIL, (Object)dto.getUserData().getEmail()).claim(USER_LOGIN, (Object)dto.getUserData().getLogin()).claim(PURCHASES, (Object)purchases).claim(LANG, (Object)this.getLanguage(dto)).signWith((Key)Keys.hmacShaKeyFor((byte[])scope.getSecretKey().getBytes(StandardCharsets.UTF_8))).setExpiration(validity.getTime()).compact();
        ActiveToken newToken = new ActiveToken();
        newToken.setToken(token);
        newToken.setActive(Boolean.TRUE);
        newToken.setDue(validity.getTime());
        newToken.setType(tokenType);
        newToken.setUserDataId(dto.getUserId());
        newToken.setScope(scope);
        return (ActiveToken)repo.save((Object)newToken);
    }

    private String getLanguage(UserTokenDTO dto) {
        UserSettingService service = (UserSettingService)this.getContext().getBean(UserSettingService.class);
        return service.findUserSetting(dto.getUserId()).getLanguage();
    }

    private List<String> findPurchases(UserTokenDTO dto) {
        Stream<Long> ids = this.purchaseRepo.findAllByDueGreaterThanAndUserDataId(Long.valueOf(System.currentTimeMillis()), dto.getUserData().getId()).stream().map(Purchase::getPurchaseShopId);
        return ids.map(x -> this.subscriptionRepo.findById(x).orElse(null)).filter(Objects::nonNull).map(Subscription::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void removeAuthToken(String token, String type, ScopeModel scope) {
        ActiveTokensRepo repo = (ActiveTokensRepo)this.getBean(ActiveTokensRepo.class);
        ActiveToken item = (ActiveToken)repo.findFirstByTokenAndActiveIsTrueAndTypeAndScope(token, type, scope).orElseThrow(() -> new LogoutException("Token not exist for type: " + type));
        item.setActive(Boolean.FALSE);
        item.setClosed(new Date());
        repo.save((Object)item);
    }

    private String getSecretKey() {
        return (String)this.getContext().getEnv("dennis.systems.security.secret");
    }

    private int getTokenValidity(ScopeModel scope) {
        Integer tokenDuration;
        if (Objects.nonNull(scope.getScopeRule()) && (tokenDuration = scope.getScopeRule().getTokenDuration()) != null && tokenDuration > 0) {
            return tokenDuration;
        }
        return (Integer)this.getContext().getEnv("dennis.systems.security.validity");
    }
}

