/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.role_validator.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import org.springframework.security.core.GrantedAuthority;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity(name="user_role")
public class UserRole
extends UserAssignableEntity
implements GrantedAuthority {
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_SIGNED = "ROLE_ANY";
    private String role;
    @Column(name="autoApply")
    private Boolean addToEveryUser;
    public Boolean autoApplyOnVirtualUser;
    @ManyToOne
    @DataTransformer(additionalClass=AuthScopeService.class, transFormWith=IdToObjectTransformer.class)
    private ScopeModel scope;

    public String getAuthority() {
        return this.role;
    }

    public String asValue() {
        String res = this.role;
        this.role = this.scope == null ? this.role + " undefined_scope" : this.role + " " + this.scope.asValue();
        return res;
    }

    public String getRole() {
        return this.role;
    }

    public Boolean getAddToEveryUser() {
        return this.addToEveryUser;
    }

    public Boolean getAutoApplyOnVirtualUser() {
        return this.autoApplyOnVirtualUser;
    }

    public ScopeModel getScope() {
        return this.scope;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setAddToEveryUser(Boolean addToEveryUser) {
        this.addToEveryUser = addToEveryUser;
    }

    public void setAutoApplyOnVirtualUser(Boolean autoApplyOnVirtualUser) {
        this.autoApplyOnVirtualUser = autoApplyOnVirtualUser;
    }

    public void setScope(ScopeModel scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRole)) {
            return false;
        }
        UserRole other = (UserRole)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addToEveryUser = this.getAddToEveryUser();
        Boolean other$addToEveryUser = other.getAddToEveryUser();
        if (this$addToEveryUser == null ? other$addToEveryUser != null : !((Object)this$addToEveryUser).equals(other$addToEveryUser)) {
            return false;
        }
        Boolean this$autoApplyOnVirtualUser = this.getAutoApplyOnVirtualUser();
        Boolean other$autoApplyOnVirtualUser = other.getAutoApplyOnVirtualUser();
        if (this$autoApplyOnVirtualUser == null ? other$autoApplyOnVirtualUser != null : !((Object)this$autoApplyOnVirtualUser).equals(other$autoApplyOnVirtualUser)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        ScopeModel this$scope = this.getScope();
        ScopeModel other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addToEveryUser = this.getAddToEveryUser();
        result = result * 59 + ($addToEveryUser == null ? 43 : ((Object)$addToEveryUser).hashCode());
        Boolean $autoApplyOnVirtualUser = this.getAutoApplyOnVirtualUser();
        result = result * 59 + ($autoApplyOnVirtualUser == null ? 43 : ((Object)$autoApplyOnVirtualUser).hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        ScopeModel $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public String toString() {
        return "UserRole(role=" + this.getRole() + ", addToEveryUser=" + this.getAddToEveryUser() + ", autoApplyOnVirtualUser=" + this.getAutoApplyOnVirtualUser() + ", scope=" + String.valueOf(this.getScope()) + ")";
    }

    public UserRole(String role, Boolean addToEveryUser, Boolean autoApplyOnVirtualUser, ScopeModel scope) {
        this.role = role;
        this.addToEveryUser = addToEveryUser;
        this.autoApplyOnVirtualUser = autoApplyOnVirtualUser;
        this.scope = scope;
    }

    public UserRole() {
    }
}

