/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.role_validator.entity;

import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.security.core.Authentication;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.TokenExpiredException;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.config.WebContext;

public class UserTokenDTO
implements Authentication,
Serializable {
    private UserData userData;
    private String token;
    private Long due;
    private String scope;
    private List<UserRole> roleList;

    public void setDue(Date due) {
        this.due = due.getTime();
    }

    public void setRoleList(List<LinkedHashMap<String, Object>> values) {
        if (this.roleList == null && values != null) {
            this.roleList = new ArrayList(values.size());
        }
        if (values == null) {
            return;
        }
        for (LinkedHashMap<String, Object> string : values) {
            UserRole role = new UserRole();
            role.setId(Long.valueOf(String.valueOf(string.getOrDefault("id", 1L))));
            role.setRole(String.valueOf(string.getOrDefault("role", 1L)));
            this.roleList.add(role);
        }
    }

    @Transient
    public void setRoleListFromGD(List<String> values) {
        if (this.roleList == null) {
            this.roleList = new ArrayList(values.size());
        }
        for (String string : values) {
            UserRole role = new UserRole();
            role.setRole(string);
            this.roleList.add(role);
        }
    }

    public boolean validate(WebContext.LocalWebContext context) throws TokenExpiredException {
        if (this.getDue() == null || this.getDue() < new Date().getTime()) {
            throw new TokenExpiredException(this.token);
        }
        return true;
    }

    public Collection<UserRole> getAuthorities() {
        return this.getRoleList();
    }

    public Object getCredentials() {
        return this.userData.getLogin();
    }

    public Object getDetails() {
        return this.userData;
    }

    public Object getPrincipal() {
        return () -> this.userData.getName();
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public Long getUserId() {
        return this.userData.getId();
    }

    public String getName() {
        return this.userData.getLogin();
    }

    public void setRoles(List<UserRole> roles) {
        this.roleList = roles;
    }

    public static UserTokenDTOBuilder builder() {
        return new UserTokenDTOBuilder();
    }

    public UserTokenDTOBuilder toBuilder() {
        return new UserTokenDTOBuilder().userData(this.userData).token(this.token).due(this.due).scope(this.scope).roleList(this.roleList);
    }

    public UserData getUserData() {
        return this.userData;
    }

    public String getToken() {
        return this.token;
    }

    public Long getDue() {
        return this.due;
    }

    public String getScope() {
        return this.scope;
    }

    public List<UserRole> getRoleList() {
        return this.roleList;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTokenDTO)) {
            return false;
        }
        UserTokenDTO other = (UserTokenDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$due = this.getDue();
        Long other$due = other.getDue();
        if (this$due == null ? other$due != null : !((Object)this$due).equals(other$due)) {
            return false;
        }
        UserData this$userData = this.getUserData();
        UserData other$userData = other.getUserData();
        if (this$userData == null ? other$userData != null : !this$userData.equals(other$userData)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        List this$roleList = this.getRoleList();
        List other$roleList = other.getRoleList();
        return !(this$roleList == null ? other$roleList != null : !((Object)this$roleList).equals(other$roleList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserTokenDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $due = this.getDue();
        result = result * 59 + ($due == null ? 43 : ((Object)$due).hashCode());
        UserData $userData = this.getUserData();
        result = result * 59 + ($userData == null ? 43 : $userData.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        List $roleList = this.getRoleList();
        result = result * 59 + ($roleList == null ? 43 : ((Object)$roleList).hashCode());
        return result;
    }

    public String toString() {
        return "UserTokenDTO(userData=" + String.valueOf(this.getUserData()) + ", token=" + this.getToken() + ", due=" + this.getDue() + ", scope=" + this.getScope() + ", roleList=" + String.valueOf(this.getRoleList()) + ")";
    }

    public UserTokenDTO(UserData userData, String token, Long due, String scope, List<UserRole> roleList) {
        this.userData = userData;
        this.token = token;
        this.due = due;
        this.scope = scope;
        this.roleList = roleList;
    }

    public UserTokenDTO() {
    }
}

