/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.ScopeException;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ScopeRuleException;
import systems.dennis.shared.form.ScopeForm;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.repository.ScopeRepo;
import systems.dennis.shared.service.ScopeService;

@Service
@DataRetrieverDescription(model=ScopeModel.class, form=ScopeForm.class, repo=ScopeRepo.class)
@DeleteStrategy(value=2)
@Primary
public class AuthScopeService
extends ScopeService {
    private static final int KEY_LENGTH = 100;
    private final ScopeRepo scopeRepo;

    public AuthScopeService(WebContext holder, ScopeRepo scopeRepo) {
        super(holder);
        this.scopeRepo = scopeRepo;
    }

    public ScopeModel preAdd(ScopeModel object) throws ItemForAddContainsIdException {
        String secretKey = ((PasswordService)this.getBean(PasswordService.class)).generateRandomPassword(100);
        object.setSecretKey(secretKey);
        return super.preAdd(object);
    }

    public ScopeModel afterAdd(ScopeModel object) {
        this.addCreatorToScope(object);
        this.assignAdminRole(object);
        return (ScopeModel)super.afterAdd((BaseEntity)object);
    }

    public ScopeModel getScopeFromRequest(HttpServletRequest req, Long userId, boolean fullAccess) {
        if (req == null) {
            throw new ScopeException("global.exceptions.failed_determine_scope");
        }
        String scopeId = req.getHeader("AUTH_SCOPE");
        if (scopeId == null) {
            throw new ScopeException("global.exceptions.failed_determine_scope");
        }
        return this.findByName(scopeId, userId, fullAccess);
    }

    private void addCreatorToScope(ScopeModel scope) {
        UserData userData = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByIdOrThrow(scope.getUserDataId());
        ((UserInScopeService)this.getBean(UserInScopeService.class)).generateAndSave(userData, scope);
    }

    private void assignAdminRole(ScopeModel scope) {
        UserRole roleAdmin = ((RoleServiceImpl)this.getBean(RoleServiceImpl.class)).generateAdminRole(scope);
        UserData userData = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByIdOrThrow(scope.getUserDataId());
        LoginPassword lp = (LoginPassword)((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin(userData.getEmail()).orElseThrow();
        ((RoleToUserService)this.getBean(RoleToUserService.class)).applyRole(roleAdmin, lp);
    }

    public Specification<ScopeModel> addSelfSpecWithUserScopes(Long userData) {
        DefaultSearchSpecification selfSpec = this.getSelfCreatedItems(userData);
        return this.addScopeSpecification((Specification)selfSpec, userData);
    }

    public Specification<ScopeModel> getAdditionalSpecification() {
        Specification additionalSpec = super.getAdditionalSpecification();
        DefaultSearchSpecification selfSpec = this.getSelfCreatedItems(this.getCurrentUser());
        return this.addScopeSpecification((Specification)selfSpec, this.getCurrentUser()).and(additionalSpec);
    }

    public ScopeModel generateAndSaveUserScope(UserData userData) {
        ScopeModel selfScope = new ScopeModel();
        selfScope.setName(UUID.randomUUID().toString());
        selfScope.setUserDataId(userData.getId());
        selfScope.setDate(new Date());
        selfScope.setSecretKey(((PasswordService)this.getBean(PasswordService.class)).generateRandomPassword(100));
        selfScope = (ScopeModel)this.scopeRepo.save((Object)selfScope);
        this.addCreatorToScope(selfScope);
        this.assignAdminRole(selfScope);
        return selfScope;
    }

    public void checkRegistrationAllowed(ScopeModel scope) {
        if (Objects.nonNull(scope.getScopeRule()) && !scope.getScopeRule().getRegistrationAllowed().booleanValue()) {
            throw new ScopeRuleException("global.exceptions.registration_not_allowed");
        }
    }

    private Specification<ScopeModel> addScopeSpecification(Specification<ScopeModel> selfSpec, Long userData) {
        List scopeIds = ((UserInScopeService)this.getBean(UserInScopeService.class)).getByUser(userData).stream().filter(x -> x.getScope() != null).map(x -> x.getScope().getId()).collect(Collectors.toList());
        DefaultSearchSpecification userInScopeSpec = QueryCase.in((String)"id", scopeIds).specification();
        return selfSpec != null ? selfSpec.or((Specification)userInScopeSpec) : userInScopeSpec;
    }
}

