/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.service.UsersPageService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;

@Service
@DataRetrieverDescription(model=LoginPassword.class, form=ChangePasswordForm.class, repo=LoginPasswordRepo.class)
public class ChangePasswordServiceImpl
extends UsersPageService {
    public ChangePasswordServiceImpl(WebContext context) {
        super(context);
    }

    public LoginPassword preEdit(LoginPassword object, LoginPassword original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        LoginPassword res = (LoginPassword)super.preEdit((BaseEntity)object, (BaseEntity)original);
        res.setPassword(((PasswordService)this.getContext().getBean(PasswordService.class)).toPassword(res.getPassword()));
        return res;
    }

    public void changePassword(LoginPassword lp) {
        LoginPasswordRepo repo = (LoginPasswordRepo)this.getRepository();
        LoginPassword newlp = (LoginPassword)repo.findByLogin(lp.getLogin()).orElseThrow(() -> new ItemNotFoundException(lp.getLogin()));
        newlp.setPassword(lp.getPassword());
        this.save((BaseEntity)newlp);
    }
}

