/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.repository.RolesToUserRepo;
import systems.dennis.auth.repository.UserInScopeRepo;
import systems.dennis.auth.repository.UserRoleRepo;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

@Service
public class DataCleanupService
extends ApplicationContext {
    public DataCleanupService(WebContext context) {
        super(context);
    }

    public Boolean cleanupData(String scopeName) {
        ScopeModel scope = ((ScopeService)this.getBean(ScopeService.class)).findByName(scopeName, this.getCurrentUser(), true);
        this.cleanupRolesToUser(scope);
        this.cleanupUsersInScope(scope);
        return true;
    }

    private void cleanupRolesToUser(ScopeModel scope) {
        RolesToUserRepo rolesToUserRepo = (RolesToUserRepo)this.getBean(RolesToUserRepo.class);
        List usersRoles = ((UserRoleRepo)this.getBean(UserRoleRepo.class)).findAll((Specification)QueryCase.equalsOf((String)"scope", (Object)scope).specification());
        Optional admin = ((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin("admin");
        for (UserRole userRole : usersRoles) {
            DefaultSearchSpecification roleSpec = QueryCase.equalsOf((String)"role", (Object)userRole).specification();
            if (admin.isPresent()) {
                roleSpec.addCase(QueryCase.notEqualsOf((String)"role", (Object)userRole));
            }
            List rolesToUsers = rolesToUserRepo.findAll((Specification)roleSpec);
            rolesToUserRepo.deleteAll((Iterable)rolesToUsers);
        }
    }

    private void cleanupUsersInScope(ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"scope", (Object)scope).specification();
        Optional admin = ((ProfilePageService)this.getBean(ProfilePageService.class)).findByEmail("admin");
        if (admin.isPresent()) {
            specification.addCase(QueryCase.notEqualsOf((String)"user", admin.get()));
        }
        List usersInScope = ((UserInScopeRepo)this.getBean(UserInScopeRepo.class)).findAll((Specification)specification);
        ((UserInScopeRepo)this.getBean(UserInScopeRepo.class)).deleteAll((Iterable)usersInScope);
    }
}

