/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.exception.InvitationException;
import systems.dennis.auth.form.InvitationForm;
import systems.dennis.auth.mail.MailSender;
import systems.dennis.auth.model.InvitationModel;
import systems.dennis.auth.repository.InvitationRepo;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=InvitationModel.class, form=InvitationForm.class, repo=InvitationRepo.class)
public class InvitationService
extends PaginationService<InvitationModel> {
    public InvitationService(WebContext holder) {
        super(holder);
    }

    public InvitationModel preAdd(InvitationModel object) throws ItemForAddContainsIdException {
        UserData inviter = ((SecurityUtils)this.getBean(SecurityUtils.class)).get().getUserData();
        ScopeModel scope = ((AuthScopeService)this.getBean(AuthScopeService.class)).getScopeFromRequest(this.getContext().getRequest(), inviter.getId(), false);
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(12, this.getInvitationDuration());
        object.setInviter(inviter);
        object.setAccepted(Boolean.valueOf(false));
        object.setScope(scope);
        object.setDate(now);
        object.setDateDue(calendar.getTime());
        return (InvitationModel)super.preAdd((BaseEntity)object);
    }

    public InvitationModel afterAdd(InvitationModel object) {
        this.sendInvitationEmail(object);
        return (InvitationModel)super.afterAdd((BaseEntity)object);
    }

    public Boolean accept(InvitationModel invitation) {
        Boolean accepted = invitation.getAccepted();
        if (accepted.booleanValue()) {
            throw new InvitationException("global.exceptions.invitation_already_accept");
        }
        Date currentDate = new Date();
        if (invitation.getDateDue().toInstant().isBefore(currentDate.toInstant())) {
            throw new InvitationException("global.exceptions.invitation_expired");
        }
        invitation.setAccepted(Boolean.valueOf(true));
        this.save((BaseEntity)invitation);
        return true;
    }

    public List<InvitationModel> getMyAcceptInvitation(Long from, Integer limit, Integer page) {
        UserData inviter = ((SecurityUtils)this.getBean(SecurityUtils.class)).get().getUserData();
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"inviter", (Object)inviter).specification().addCase(QueryCase.equalsOf((String)"accepted", (Object)true));
        return this.find(specification, from, limit, page).getContent();
    }

    public void addUserToScope(InvitationModel invitation) {
        UserData user = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByLogin(invitation.getEmail()).orElseThrow(() -> new ItemNotFoundException(invitation.getEmail()));
        ScopeModel scope = invitation.getScope();
        if (!((UserInScopeService)this.getBean(UserInScopeService.class)).isRelationExist(user, scope)) {
            ((UserInScopeService)this.getBean(UserInScopeService.class)).generateAndSave(user, scope);
        }
    }

    private void sendInvitationEmail(InvitationModel object) {
        String inviteUrl = this.generateInviteUrl(object);
        String content = this.prepareEmailContent(object, inviteUrl);
        String lang = object.getInviter().getPreferredLanguage();
        String title = this.getContext().getMessageTranslation("email.invitation.title", lang);
        ((MailSender)this.getBean(MailSender.class)).sendMail(Collections.singletonList(object.getEmail()), content, title);
    }

    private String prepareEmailContent(InvitationModel invitation, String inviteUrl) {
        HashMap<String, String> templateModel = new HashMap<String, String>();
        templateModel.put("inviter", invitation.getInviter().getLogin());
        templateModel.put("invitationLink", inviteUrl);
        String path = invitation.getInviter().getPreferredLanguage() + "/invitation.html";
        return ((MailSender)this.getBean(MailSender.class)).processHtmlTemplate(path, templateModel);
    }

    private String generateInviteUrl(InvitationModel object) {
        ScopeModel scope = object.getScope();
        String baseUrl = scope.getUrl();
        return baseUrl + this.getInvitationInfoPath() + "?id=" + object.getId();
    }

    private int getInvitationDuration() {
        return (Integer)this.getContext().getEnv("invitation.duration", (Object)43200);
    }

    private String getInvitationInfoPath() {
        return (String)this.getContext().getEnv("app.invitation.info.path", (Object)"/invitation/info");
    }
}

