/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.auth.form.LoginPasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.repository.VirtualLoginPasswordRepo;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.PaginationRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
@DataRetrieverDescription(model=LoginPassword.class, form=LoginPasswordForm.class, repo=LoginPasswordRepo.class)
@DeleteStrategy(value=2)
public class LoginPasswordService
extends PaginationService<LoginPassword> {
    private WebContext.LocalWebContext context;
    private final LoginPasswordRepo repo;
    private final UserDataRepository userRepository;
    private final RoleServiceImpl roleService;
    private final PasswordService passwordService;
    private final RoleToUserService roleToUserService;

    public LoginPasswordService(WebContext context, LoginPasswordRepo repo, UserDataRepository userDataRepository, RoleServiceImpl roleService, PasswordService passwordService, RoleToUserService roleToUserService) {
        super(context);
        this.context = WebContext.LocalWebContext.of((String)"login.password.service", (WebContext)context);
        this.repo = repo;
        this.userRepository = userDataRepository;
        this.roleService = roleService;
        this.passwordService = passwordService;
        this.roleToUserService = roleToUserService;
    }

    public PaginationRepository<LoginPassword> getRepository() {
        return this.repo;
    }

    public UserData saveUserData(RegistrationForm form) {
        UserData data = new UserData();
        data.setLogin(form.getEmail());
        data.setEmail(form.getEmail());
        data.setName(form.getName());
        return (UserData)this.userRepository.save((Object)data);
    }

    public LoginPassword formToPojo(RegistrationForm form) {
        return LoginPassword.from((RegistrationForm)form);
    }

    public LoginPassword preAdd(LoginPassword object) throws ItemForAddContainsIdException {
        object.setPassword(this.passwordService.toPassword(object.getPassword()));
        return object;
    }

    public void saveUserRoles(LoginPassword lp, ScopeModel scope) {
        this.roleService.applyRolesToUser(lp, scope);
    }

    public List<String> findUsersByLogin(String text) {
        Page res = this.repo.findAll((Specification)QueryCase.containsInSensitive((String)"login", (Object)text).string().specification(), (Pageable)PageRequest.of((int)0, (int)50));
        ArrayList<String> logins = new ArrayList<String>();
        res.forEach(x -> logins.add(x.getLogin()));
        return logins;
    }

    public Optional<LoginPassword> findUserByLogin(String login) {
        return this.repo.findOne((Specification)QueryCase.equalsOf((String)"login", (Object)login).string().specification());
    }

    public Optional<RolesToUser> findUserAssigment(String user, Long roleId) throws ItemNotFoundException {
        LoginPassword res = (LoginPassword)this.findUserByLogin(user).orElseThrow(() -> new ItemNotFoundException(user));
        UserRole role = (UserRole)this.roleService.findById(roleId).orElseThrow(() -> new ItemNotFoundException(roleId));
        return this.roleToUserService.findByRoleAndUser(role, res);
    }

    public RolesToUser assignUser(String userLogin, Long roleId) {
        return this.roleToUserService.applyRole((UserRole)this.roleService.findById(roleId).orElseThrow(), (LoginPassword)this.repo.findByLogin(userLogin).orElseThrow());
    }

    public Optional<LoginPassword> findById(Long id) {
        Optional res = super.findById(id);
        if (res.isPresent()) {
            LoginPassword newLP = (LoginPassword)((BeanCopier)this.getBean(BeanCopier.class)).copy(res.get(), LoginPassword.class);
            newLP.setPassword("*****");
            return Optional.of(newLP);
        }
        return res;
    }

    public Page<LoginPassword> search(MagicRequest request) {
        if (!this.getUtils().isAdmin()) {
            throw new AccessDeniedException("only.admin.can.search_this");
        }
        Page res = super.search(request);
        ArrayList<LoginPassword> loginPasswords = new ArrayList<LoginPassword>();
        for (LoginPassword r : res) {
            LoginPassword newLP = (LoginPassword)((BeanCopier)this.getBean(BeanCopier.class)).copy((Object)r, LoginPassword.class);
            newLP.setPassword("********");
            loginPasswords.add(newLP);
        }
        res.getContent().clear();
        res.getContent().addAll(loginPasswords);
        return res;
    }

    public LoginPassword findOrThrow(LoginPassword loginPassword) {
        return this.findOrThrow(loginPassword, true);
    }

    public Optional<LoginPassword> login(String login, String toPassword, String code) {
        Optional res = this.repo.login(login, toPassword);
        if (res.isEmpty() || ((LoginPassword)res.get()).getTwoFactor() == null && ((LoginPassword)res.get()).getTwoFactor() == Boolean.FALSE) {
            return res;
        }
        String security = ((SecurityUtils)this.context.getBean(SecurityUtils.class)).getTOTPCode(this, login);
        if (security == null) {
            return res;
        }
        if (!security.equalsIgnoreCase(code)) {
            throw new AuthorizationNotFoundException("Code was wrong! ");
        }
        return res;
    }

    public LoginPassword findOrThrow(LoginPassword loginPassword, boolean real) {
        if (real) {
            Optional res = this.login(loginPassword.getLogin(), loginPassword.getPassword(), loginPassword.getTwoFactorCode());
            if (res.isEmpty()) {
                throw new AuthorizationFailedException(loginPassword.getLogin());
            }
            return (LoginPassword)res.get();
        }
        Optional res = ((VirtualLoginPasswordRepo)this.context.getBean(VirtualLoginPasswordRepo.class)).login(loginPassword.getLogin(), this.passwordService.toPassword(loginPassword.getPassword()));
        if (res.isEmpty() || !((VirtualLoginPassword)res.get()).getIsActive().booleanValue()) {
            throw new AccessDeniedException("User is not found or inactive");
        }
        Long user = ((VirtualLoginPassword)res.get()).getUserDataId();
        UserData userData = (UserData)((UserDataRepository)this.context.getBean(UserDataRepository.class)).findById((Object)user).orElseThrow(() -> new AccessDeniedException("The managing owner not found"));
        String login = userData.getLogin();
        return (LoginPassword)((LoginPasswordRepo)this.context.getBean(LoginPasswordRepo.class)).findByLogin(login).orElseThrow(() -> new AccessDeniedException("User is not present owned by virtual user"));
    }

    public boolean isOnlyOne() {
        return this.getRepository().count() < 2L;
    }
}

