/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.entity.UserDataForm;
import systems.dennis.auth.exception.VerificationException;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(form=UserDataForm.class, model=UserData.class, repo=UserDataRepository.class)
@DeleteStrategy(value=2)
public class ProfilePageService
extends PaginationService<UserData> {
    public ProfilePageService(WebContext context) {
        super(context);
    }

    public UserData preAdd(UserData object) throws ItemForAddContainsIdException {
        object.setLastUpdate(new Date());
        return (UserData)super.preAdd((BaseEntity)object);
    }

    public UserData preEdit(UserData object, UserData original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        object.setLastUpdate(new Date());
        return (UserData)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public Optional<UserData> findByLogin(String login) {
        return this.getRepository().findByLogin(login);
    }

    public Optional<UserData> findByEmail(String email) {
        return this.getRepository().findFirst((Specification)QueryCase.equalsOf((String)"email", (Object)email).specification());
    }

    public UserDataRepository getRepository() {
        return (UserDataRepository)super.getRepository();
    }

    public UserData savePhoto(Long profileId, String url) {
        UserData item = (UserData)this.getRepository().findById((Object)profileId).orElseThrow(() -> new ItemNotFoundException(profileId));
        this.getUtils().isMy((Object)item);
        item.setImagePath(url);
        return (UserData)this.save((BaseEntity)item);
    }

    public String getCurrentUserImage() {
        UserData res = (UserData)this.findById(this.getCurrentUser(), (Exception)new ItemNotFoundException(this.getCurrentUser()));
        return res.getImagePath() == null ? "/images/profile_photo.png" : res.getImagePath();
    }

    public List<UserRole> myRoles(ScopeModel scope) {
        return ((RoleServiceImpl)this.getBean(RoleServiceImpl.class)).getMyRoles(scope);
    }

    public void checkMy(UserData object) {
        if (!this.getCurrentUser().equals(object.getId())) {
            throw new ItemNotUserException();
        }
    }

    public void checkVerifiedUser(UserData user, ScopeModel scope) {
        if (Objects.nonNull(scope.getScopeRule()) && scope.getScopeRule().getVerificationRequired().booleanValue() && !user.getVerified().booleanValue()) {
            throw new VerificationException("global.exceptions.user_not_verified");
        }
    }
}

