/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.entity.Purchase;
import systems.dennis.auth.entity.Subscription;
import systems.dennis.auth.exception.PurchaseException;
import systems.dennis.auth.form.PurchaseForm;
import systems.dennis.auth.repository.PurchaseRepo;
import systems.dennis.auth.service.SubscriptionService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@DataRetrieverDescription(form=PurchaseForm.class, model=Purchase.class, repo=PurchaseRepo.class)
@Service
public class PurchaseService
extends PaginationService<Purchase> {
    public PurchaseService(WebContext holder) {
        super(holder);
    }

    public PurchaseRepo getRepository() {
        return (PurchaseRepo)super.getRepository();
    }

    public Purchase findAlreadyRegisteredSubscription(Long userId, Long shopId) {
        return this.getRepository().findFirstByUserDataIdAndPurchaseShopId(userId, shopId).orElse(null);
    }

    public Purchase buy(Long id) {
        SubscriptionService service = (SubscriptionService)this.getBean(SubscriptionService.class);
        Subscription item = (Subscription)service.findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        this.checkPurchase(item);
        return this.pay(item);
    }

    private Purchase pay(Subscription item) {
        Purchase purchase = new Purchase();
        purchase.setPurchasePrice(item.getPrice());
        purchase.setPurchaseShopId(item.getId());
        purchase.setDate(new Date());
        purchase.setPayed(new Date());
        purchase.setActive(Boolean.valueOf(true));
        purchase.setUserDataId(this.getUtils().getUserDataId());
        purchase.setDue(this.calculateDuration(item));
        return (Purchase)((PurchaseService)this.getBean(PurchaseService.class)).save((BaseEntity)purchase);
    }

    private Long calculateDuration(Subscription item) {
        long duration = item.getDurationInDays();
        duration = duration * 24L * 60L * 60L * 1000L;
        long currentTime = System.currentTimeMillis();
        return currentTime + duration;
    }

    public void checkPurchase(Subscription item) {
        if (!item.getActive().booleanValue()) {
            throw new PurchaseException("Purchase is not active any more");
        }
        PurchaseService purchaseService = (PurchaseService)this.getBean(PurchaseService.class);
        if (purchaseService.findAlreadyRegisteredSubscription(this.getContext().getCurrentUser(), item.getId()) != null && !item.getAllowMultiplePurchases().booleanValue()) {
            throw new PurchaseException("Item has already been sold for this user");
        }
    }

    public List<Purchase> findMy() {
        List res = this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"userDataId", (Object)this.getCurrentUser()).specification());
        SubscriptionService service = (SubscriptionService)this.getBean(SubscriptionService.class);
        res.forEach(x -> x.setSubscription((Subscription)service.findById(x.getPurchaseShopId()).orElse(null)));
        return res;
    }
}

