/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.form.RoleForm;
import systems.dennis.auth.repository.RolesToUserRepo;
import systems.dennis.auth.repository.UserRoleRepo;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.auth.service.UserAssignableService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=UserRole.class, form=RoleForm.class, repo=UserRoleRepo.class)
public class RoleServiceImpl
extends PaginationService<UserRole>
implements UserAssignableService<UserRole> {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    private final RoleToUserService roleToUserService;

    public RoleServiceImpl(WebContext context, RoleToUserService roleToUserService) {
        super(context);
        this.roleToUserService = roleToUserService;
    }

    public boolean existsByName(String value) {
        return this.getRepository().existsByRole(value);
    }

    public UserRole findFirstByName(String value, Long id) {
        return this.getRepository().findFirstByRoleAndId(value, id).orElse(null);
    }

    public void applyRolesToUser(LoginPassword lp, ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"addToEveryUser", (Object)Boolean.TRUE).specification().addCase(QueryCase.equalsOf((String)"scope", (Object)scope));
        List rolesAutoApply = this.getRepository().findAll((Specification)specification);
        for (UserRole role : rolesAutoApply) {
            this.roleToUserService.applyRole(role, lp);
        }
    }

    public UserRoleRepo getRepository() {
        return (UserRoleRepo)super.getRepository();
    }

    public List<UserRole> getMyRoles(ScopeModel scope) {
        Long rolesToUSer = this.getCurrentUser();
        SecurityUtils utils = (SecurityUtils)this.getUtils();
        LoginPassword login = ((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin(utils.get().getUserData().getLogin()).orElse(null);
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"scope", (Object)scope).complex("role").specification().addCase(QueryCase.equalsOf((String)"password", (Object)login));
        List rolesToUsers = ((RoleToUserService)this.getBean(RoleToUserService.class)).getRepository().findAll((Specification)specification);
        ArrayList<UserRole> res = new ArrayList<UserRole>();
        rolesToUsers.forEach(x -> res.add(x.getRole()));
        return res;
    }

    public boolean deAssignRole(Long roleId, Long passwordId) {
        return ((RoleToUserService)this.getBean(RoleToUserService.class)).removeRole((UserRole)this.getRepository().findById((Object)roleId).orElseThrow(() -> new ItemNotFoundException("Role not found -> " + roleId)), (LoginPassword)((LoginPasswordService)this.getBean(LoginPasswordService.class)).findById(passwordId).orElseThrow(() -> new ItemNotFoundException("Login Password not found: " + passwordId)));
    }

    public boolean deAssignRole(Long roleId, String login) {
        return ((RoleToUserService)this.getBean(RoleToUserService.class)).removeRole((UserRole)this.getRepository().findById((Object)roleId).orElseThrow(() -> new ItemNotFoundException("Role not found -> " + roleId)), (LoginPassword)((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin(login).orElseThrow(() -> new ItemNotFoundException("Login Password not found: " + login)));
    }

    public List<UserData> usersByRole(Long roleId) {
        List rolesToUser = ((RolesToUserRepo)this.getBean(RolesToUserRepo.class)).findAll((Specification)QueryCase.equalsOf((String)"role", ((UserRoleRepo)this.getBean(UserRoleRepo.class)).findById((Object)roleId).orElseThrow(() -> new ItemNotFoundException(roleId))).specification());
        ProfilePageService userDataService = (ProfilePageService)this.getBean(ProfilePageService.class);
        return rolesToUser.stream().map(x -> userDataService.findByLogin(x.getPassword().getLogin()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Boolean assignRole(Long roleId, String login) {
        LoginPassword lp = (LoginPassword)((LoginPasswordService)this.getBean(LoginPasswordService.class)).findUserByLogin(login).orElseThrow(() -> new ItemNotFoundException("Login Password not found: " + login));
        UserRole role = (UserRole)this.getRepository().findById((Object)roleId).orElseThrow(() -> new ItemNotFoundException(login));
        this.roleToUserService.applyRole(role, lp);
        return true;
    }

    public UserRole generateAdminRole(ScopeModel scope) {
        UserRole userRole = new UserRole();
        userRole.setRole("ROLE_ADMIN");
        userRole.setScope(scope);
        userRole.setAddToEveryUser(Boolean.valueOf(false));
        return (UserRole)this.getRepository().save((Object)userRole);
    }

    public boolean isRelationExist(String role, ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"role", (Object)role).specification().addCase(QueryCase.equalsOf((String)"scope", (Object)scope));
        return this.count((Specification)specification) > 0L;
    }
}

