/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.exception.RoleAlreadyAssignedException;
import systems.dennis.auth.exception.RoleAlreadyUnAssignedException;
import systems.dennis.auth.form.RoleToUserForm;
import systems.dennis.auth.repository.RolesToUserRepo;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=RolesToUser.class, form=RoleToUserForm.class, repo=RolesToUserRepo.class)
public class RoleToUserService
extends PaginationService<RolesToUser> {
    public RoleToUserService(WebContext context) {
        super(context);
    }

    public RolesToUserRepo getRepository() {
        return (RolesToUserRepo)super.getRepository();
    }

    public List<UserRole> findByOwner(LoginPassword password, ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"scope", (Object)scope).complex("role").specification().addCase(QueryCase.equalsOf((String)"password", (Object)password));
        return this.getRepository().findAll((Specification)specification).stream().map(RolesToUser::getRole).collect(Collectors.toList());
    }

    public RolesToUser applyRole(UserRole role, LoginPassword lp) {
        RolesToUser rolesToUser = new RolesToUser();
        rolesToUser.setRole(role);
        rolesToUser.setPassword(lp);
        rolesToUser.setUserDataId(Long.valueOf(1L));
        if (this.existForUser(role, lp)) {
            throw new RoleAlreadyAssignedException(role);
        }
        return (RolesToUser)this.getRepository().save((Object)rolesToUser);
    }

    private boolean existForUser(UserRole role, LoginPassword lp) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"password", (Object)lp).specification().addCase(QueryCase.equalsOf((String)"role", (Object)role));
        return this.count((Specification)specification) > 0L;
    }

    public RolesToUser preAdd(RolesToUser object) throws ItemForAddContainsIdException {
        if (this.getRepository().existsByRoleAndPassword(object.getRole(), object.getPassword())) {
            throw new RoleAlreadyAssignedException(object.getRole());
        }
        return (RolesToUser)super.preAdd((BaseEntity)object);
    }

    public RolesToUser preDelete(RolesToUser object) {
        if (this.getRepository().existsByRoleAndPassword(object.getRole(), object.getPassword())) {
            throw new RoleAlreadyAssignedException(object.getRole());
        }
        return (RolesToUser)super.preDelete((BaseEntity)object);
    }

    public boolean removeRole(UserRole role, LoginPassword lp) {
        RolesToUser rolesToUser = new RolesToUser();
        rolesToUser.setRole(role);
        rolesToUser.setPassword(lp);
        rolesToUser.setUserDataId(Long.valueOf(1L));
        if (!this.getRepository().existsByRoleAndPassword(role, lp)) {
            throw new RoleAlreadyUnAssignedException(role);
        }
        Optional roleToRemove = this.findByRoleAndUser(role, lp);
        this.getRepository().delete((Object)((RolesToUser)roleToRemove.get()));
        return true;
    }

    public Optional<RolesToUser> findByRoleAndUser(UserRole roleId, LoginPassword password) {
        return this.getRepository().findByPasswordAndRole(password, roleId);
    }
}

