/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.exception.DuplicateRelationException;
import systems.dennis.auth.form.UserInScopeForm;
import systems.dennis.auth.mail.MailSender;
import systems.dennis.auth.model.VerificationTokenModel;
import systems.dennis.auth.repository.UserInScopeRepo;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.VerificationTokenService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=UserInScopeModel.class, form=UserInScopeForm.class, repo=UserInScopeRepo.class)
@DeleteStrategy(value=2)
public class UserInScopeService
extends PaginationService<UserInScopeModel> {
    public UserInScopeService(WebContext holder) {
        super(holder);
    }

    public UserInScopeModel afterAdd(UserInScopeModel object) {
        ScopeModel scope = object.getScope();
        this.sendVerificationEmail(scope, object.getUser());
        return (UserInScopeModel)super.afterAdd((BaseEntity)object);
    }

    public void sendVerificationEmail(ScopeModel scope, UserData userData) {
        if (Objects.nonNull(scope.getScopeRule()) && scope.getScopeRule().getVerificationRequired().booleanValue() && (userData.getVerified() == null || !userData.getVerified().booleanValue())) {
            VerificationTokenModel verificationToken = ((VerificationTokenService)this.getBean(VerificationTokenService.class)).saveToken(userData, this.getVerificationTokenDuration(scope));
            this.generateConfirmationEmail(userData, verificationToken, scope);
        }
    }

    public boolean isRelationExist(UserData user, ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"user", (Object)user).specification().addCase(QueryCase.equalsOf((String)"scope", (Object)scope));
        return this.count((Specification)specification) > 0L;
    }

    public UserInScopeModel generateAndSave(UserData user, ScopeModel scope) {
        UserInScopeModel userInScope = new UserInScopeModel();
        userInScope.setUser(user);
        userInScope.setScope(scope);
        if (this.isRelationExist(user, scope)) {
            throw new DuplicateRelationException("global.exceptions.duplicate.user_in_scope");
        }
        return (UserInScopeModel)this.save((BaseEntity)userInScope);
    }

    public List<UserInScopeModel> getByUser(Long userId) {
        UserData userData = (UserData)((ProfilePageService)this.getBean(ProfilePageService.class)).findByIdOrThrow(userId);
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"user", (Object)userData).specification();
        return this.getRepository().findAll((Specification)specification);
    }

    public UserInScopeModel getByUserAndScope(UserData user, ScopeModel scope) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"user", (Object)user).specification().addCase(QueryCase.equalsOf((String)"scope", (Object)scope));
        return (UserInScopeModel)this.getRepository().findFirst((Specification)specification).orElseThrow(() -> new ItemNotFoundException((DefaultForm)user));
    }

    private void generateConfirmationEmail(UserData userData, VerificationTokenModel verificationToken, ScopeModel scope) {
        String url = scope.getVerificationUrl() + this.getVerificationScopePath() + "?token=" + verificationToken.getToken() + "&scope=" + scope.getName();
        String path = userData.getPreferredLanguage() + "/confirmation.html";
        HashMap<String, CallSite> templateParameters = new HashMap<String, CallSite>();
        templateParameters.put("link", (CallSite)((Object)url));
        String content = ((MailSender)this.getBean(MailSender.class)).processHtmlTemplate(path, templateParameters);
        String title = this.getContext().getMessageTranslation("email.confirmation.title", userData.getPreferredLanguage());
        ((MailSender)this.getBean(MailSender.class)).sendMail(Collections.singletonList(userData.getEmail()), content, title);
    }

    private int getVerificationTokenDuration(ScopeModel scope) {
        Integer tokenDuration;
        if (Objects.nonNull(scope.getScopeRule()) && (tokenDuration = scope.getScopeRule().getVerificationTokenDuration()) != null && tokenDuration > 0) {
            return tokenDuration;
        }
        return (Integer)this.getContext().getEnv("verification.token.duration.account-confirmation", (Object)43200);
    }

    private String getVerificationScopePath() {
        return (String)this.getContext().getEnv("app.verification.scope.path", (Object)"/verification/verify_scope");
    }
}

