/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.entity.LoginHistory;
import systems.dennis.auth.repository.LoginHistoryRepository;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.model.ScopeModel;

@Service
public class UserServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final UserDataRepository userRepository;
    private final TokenProvider tokenProvider;
    private final LoginHistoryRepository historyRepository;
    private final PasswordService passwordService;
    private final LoginPasswordService service;

    public UserServiceImpl(UserDataRepository userRepository, TokenProvider tokenProvider, LoginHistoryRepository historyRepository, PasswordService passwordService, LoginPasswordService service) {
        this.userRepository = userRepository;
        this.tokenProvider = tokenProvider;
        this.historyRepository = historyRepository;
        this.passwordService = passwordService;
        this.service = service;
    }

    public UserTokenDTO authorize(LoginPassword password, ScopeModel scope) {
        LoginPassword res = null;
        password.setPassword(this.passwordService.toPassword(password.getPassword()));
        try {
            res = this.service.findOrThrow(password, true);
            if (res == null) {
                throw new AccessDeniedException(password.getLogin());
            }
        }
        catch (AccessDeniedException e) {
            throw new AuthorizationFailedException(password.getLogin());
        }
        UserData userData = this.createNew(res);
        UserTokenDTO dto = new UserTokenDTO();
        dto.setUserData(userData);
        log.debug("Start authorizing , creating token: {}", (Object)password.getLogin());
        List roles = this.passwordService.getRoles(res, scope);
        ActiveToken token = this.tokenProvider.createToken(dto, "DEFAULT", roles, scope);
        dto.setToken(token.getToken());
        dto.setRoles(roles);
        dto.setDue(token.getDue());
        LoginHistory history = new LoginHistory();
        log.debug("TRacing Login history started");
        history.setUserDataId(userData.getId());
        history.setToken(token.getToken());
        history.setLogin(userData.getLogin());
        this.historyRepository.save((Object)history);
        log.debug("TRacing Login history finished");
        return dto;
    }

    public UserTokenDTO authorizeVirtual(LoginPassword password, ScopeModel scope) {
        LoginPassword res = null;
        password.setPassword(this.passwordService.toPassword(password.getPassword()));
        try {
            res = this.service.findOrThrow(password, false);
            if (res == null) {
                throw new AccessDeniedException(password.getLogin());
            }
        }
        catch (AccessDeniedException e) {
            throw new AuthorizationFailedException(password.getLogin());
        }
        UserData userData = this.createNew(res);
        UserTokenDTO dto = new UserTokenDTO();
        dto.setUserData(userData);
        log.debug("Start authorizing , creating token: {}", (Object)password.getLogin());
        List roles = this.passwordService.getRoles(res, scope);
        ActiveToken token = this.tokenProvider.createToken(dto, "VIRTUAL", roles, scope);
        dto.setToken(token.getToken());
        dto.setRoles(roles);
        dto.setDue(token.getDue());
        LoginHistory history = new LoginHistory();
        log.debug("TRacing Login history started");
        history.setUserDataId(userData.getId());
        history.setToken(token.getToken());
        history.setLogin(userData.getLogin());
        this.historyRepository.save((Object)history);
        log.debug("Tracing Login history finished");
        return dto;
    }

    private UserData createNew(LoginPassword principal) {
        UserData temp = new UserData();
        temp.setLogin(principal.getLogin());
        Optional user = this.userRepository.findByLogin(temp.getLogin());
        return user.orElseGet(() -> this.createUser(temp));
    }

    private UserData createUser(UserData temp) {
        UserData newUserData = new UserData();
        newUserData.setLogin(temp.getLogin());
        newUserData.setEmail(temp.getLogin());
        this.userRepository.save((Object)newUserData);
        return newUserData;
    }

    public void logout() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

