/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.Optional;
import java.util.TimeZone;
import org.springframework.stereotype.Service;
import systems.dennis.auth.form.UserSettingForm;
import systems.dennis.auth.model.UserSettingModel;
import systems.dennis.auth.repository.UserSettingRepo;
import systems.dennis.auth.service.UserAssignableService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=UserSettingModel.class, form=UserSettingForm.class, repo=UserSettingRepo.class)
public class UserSettingService
extends PaginationService<UserSettingModel>
implements UserAssignableService<UserSettingModel> {
    public UserSettingService(WebContext holder) {
        super(holder);
    }

    public UserSettingModel preAdd(UserSettingModel object) throws ItemForAddContainsIdException {
        if (object.getId() == null) {
            UserSettingRepo repo = (UserSettingRepo)this.getRepository();
            Optional item = repo.findFirstByUserDataId(this.getCurrentUser());
            item.ifPresent(userSettingModel -> object.setId(userSettingModel.getId()));
        }
        return (UserSettingModel)super.preAdd((BaseEntity)object);
    }

    public UserSettingModel findUserSetting(Long userId) {
        UserSettingRepo repo = (UserSettingRepo)this.getRepository();
        return repo.findFirstByUserDataId(userId).orElseGet(() -> this.createNewSetting(repo));
    }

    private UserSettingModel createNewSetting(UserSettingRepo repo) {
        UserSettingModel model = new UserSettingModel();
        model.setTimeZone(TimeZone.getDefault());
        model.setLanguage("en");
        return (UserSettingModel)repo.save((Object)model);
    }
}

