/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.VerificationTokenException;
import systems.dennis.auth.form.VerificationTokenForm;
import systems.dennis.auth.model.VerificationTokenModel;
import systems.dennis.auth.repository.VerificationTokenRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=VerificationTokenModel.class, form=VerificationTokenForm.class, repo=VerificationTokenRepo.class)
public class VerificationTokenService
extends PaginationService<VerificationTokenModel> {
    private static final int KEY_LENGTH = 15;

    public VerificationTokenService(WebContext holder) {
        super(holder);
    }

    public VerificationTokenModel saveToken(UserData userData, int duration) {
        VerificationTokenModel model = new VerificationTokenModel();
        String token = this.generateToken();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, duration);
        model.setToken(token);
        model.setExpirationDate(calendar.getTime());
        model.setUserData(userData);
        return (VerificationTokenModel)this.save((BaseEntity)model);
    }

    public void validateVerificationToken(String token) {
        Date currentDate = new Date();
        VerificationTokenModel verificationToken = this.getByToken(token);
        if (currentDate.after(verificationToken.getExpirationDate())) {
            throw new VerificationTokenException("global.exceptions.token.expired");
        }
    }

    public void deleteToken(String token) {
        VerificationTokenModel verificationToken = this.getByToken(token);
        this.delete(verificationToken.getId());
    }

    public VerificationTokenModel getByToken(String token) {
        return (VerificationTokenModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"token", (Object)token).specification()).orElseThrow(() -> new ItemNotFoundException(token));
    }

    public void deleteActiveTokens(UserData userData) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"userData", (Object)userData).specification().addCase(QueryCase.moreOrEquals((String)"expirationDate", (Object)new Date()));
        List tokens = this.getRepository().findAll((Specification)specification);
        for (VerificationTokenModel token : tokens) {
            this.getRepository().delete((Object)token);
        }
    }

    private String generateToken() {
        BytesKeyGenerator tokenGenerator = KeyGenerators.secureRandom((int)15);
        return new String(Base64.encodeBase64URLSafe((byte[])tokenGenerator.generateKey()), StandardCharsets.US_ASCII);
    }
}

