/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.service;

import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.auth.form.VirtualLoginPasswordForm;
import systems.dennis.auth.repository.VirtualLoginPasswordRepo;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.QueryObject;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=VirtualLoginPassword.class, form=VirtualLoginPasswordForm.class, repo=VirtualLoginPasswordRepo.class)
public class VirtualLoginPasswordService
extends PaginationService<VirtualLoginPassword> {
    private final PasswordService service;

    public VirtualLoginPasswordService(WebContext holder, PasswordService service) {
        super(holder);
        this.service = service;
    }

    public VirtualLoginPassword create() {
        VirtualLoginPassword password = new VirtualLoginPassword();
        String pass = this.service.generateRandomPassword(15);
        password.setPassword(this.service.toPassword(pass));
        String userName = this.service.generateRandomUsername();
        password.setName(userName);
        password.setIsActive(Boolean.valueOf(true));
        password.setTmp(pass);
        VirtualLoginPassword res = (VirtualLoginPassword)super.save((BaseEntity)password);
        res.setPassword(pass);
        return res;
    }

    public void markViewed(VirtualLoginPassword virtualLoginPassword) {
        if (virtualLoginPassword.getId() == null) {
            throw new IllegalArgumentException("Password id should not be null");
        }
        virtualLoginPassword.setTmp("");
        virtualLoginPassword.setViewed(Boolean.valueOf(true));
        this.getRepository().save((Object)virtualLoginPassword);
    }

    public List<QueryCase> getAdditionalCases(QueryObject<String> parameters) {
        if (!this.getUtils().hasRole("ROLE_ADMIN_VIEW_ALL_VD")) {
            return Collections.singletonList(QueryCase.equalsOf((String)"userDataId", (Object)this.getCurrentUser()));
        }
        return Collections.emptyList();
    }
}

