/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.util;

import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.TwillioClient;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.mail.MailSender;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.mail.EmailSender;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.utils.ApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PasswordService
extends ApplicationContext {
    private final LoginPasswordRepo loginPasswordRepo;
    private final RoleToUserService roleToUserService;
    private final EmailSender emailSender;
    private final TwillioClient twillioClient;

    public PasswordService(WebContext context, LoginPasswordRepo loginPasswordRepo, RoleToUserService roleToUserService, EmailSender emailSender, TwillioClient twillioClient) {
        super(context);
        this.loginPasswordRepo = loginPasswordRepo;
        this.roleToUserService = roleToUserService;
        this.emailSender = emailSender;
        this.twillioClient = twillioClient;
    }

    public static void main(String[] args) {
        System.out.println(PasswordService.tpw((String)"admin"));
    }

    public static String tpw(String password) {
        if (password == null) {
            throw new IllegalArgumentException("User's password is not present to login");
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update("usb".getBytes());
        md.update(password.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte byteDatum : byteData) {
            sb.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public String toPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("User's password is not present to login");
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        if (this.getSalt() != null) {
            md.update(this.getSalt().getBytes());
        }
        md.update(password.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte byteDatum : byteData) {
            sb.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public LoginPassword login(LoginPassword password) throws AccessDeniedException {
        return (LoginPassword)this.loginPasswordRepo.login(password.getLogin(), this.toPassword(password.getPassword())).orElseThrow(() -> new AccessDeniedException("Not user / password combination found"));
    }

    public String generateRandomPassword(int len) {
        return PasswordService.generate((String)this.getPasswordChars(), (int)len);
    }

    public static String generateRandomKey(int len, String chars) {
        return PasswordService.generate((String)chars, (int)len);
    }

    private static String generate(String chars, int len) {
        Random rnd = new Random();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(chars.charAt(rnd.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public List<UserRole> getRoles(LoginPassword password, ScopeModel scope) {
        return this.roleToUserService.findByOwner(password, scope);
    }

    public String reset(UserData dta) throws ItemNotFoundException {
        LoginPassword user = (LoginPassword)this.loginPasswordRepo.findByLogin(dta.getLogin()).orElseThrow(() -> new ItemNotFoundException(dta.getLogin()));
        String randomPswrd = UUID.randomUUID().toString().substring(0, 8);
        user.setPassword(this.toPassword(randomPswrd));
        this.loginPasswordRepo.save((Object)user);
        this.generateAndSendResetMessage(dta, randomPswrd);
        return "restored_by_email";
    }

    private void generateAndSendResetMessage(UserData userData, String password) {
        String path = userData.getPreferredLanguage() + "/reset_password.html";
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        templateParameters.put("password", password);
        String content = ((MailSender)this.getBean(MailSender.class)).processHtmlTemplate(path, templateParameters);
        String title = this.getContext().getMessageTranslation("email.reset_password.title", userData.getPreferredLanguage());
        ((MailSender)this.getBean(MailSender.class)).sendMail(Collections.singletonList(userData.getEmail()), content, title);
    }

    public String generateRandomUsername() {
        return PasswordService.generate((String)this.getUserNameChars(), (int)10);
    }

    private String getPasswordChars() {
        return (String)this.getContext().getEnv("global.auth.password.chars", (Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%&+_&:-(*)'[{}]/\\\\}");
    }

    private String getUserNameChars() {
        return (String)this.getContext().getEnv("global.auth.username.chars", (Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghi");
    }

    private String getSalt() {
        return (String)this.getContext().getEnv("global.auth.salt");
    }
}

