/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.auth.validators;

import java.util.Optional;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.validation.ValueValidator;

public class EmailExistenceValidator
implements ValueValidator<Object, String> {
    public ValidationResult validate(Class<?> serviceClass, Object element, String field, String value, boolean edit, WebContext.LocalWebContext context) {
        Optional userData = ((ProfilePageService)context.getBean(ProfilePageService.class)).findByEmail(value);
        if (userData.isPresent()) {
            try {
                UserData currentUser = ((SecurityUtils)context.getBean(SecurityUtils.class)).get().getUserData();
                if (!currentUser.getEmail().equals(value)) {
                    return ValidationResult.fail((String)"email.already.registered");
                }
            }
            catch (Exception e) {
                return ValidationResult.fail((String)"email.already.registered");
            }
        }
        return ValidationResult.PASSED;
    }
}

