/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.annotation;

import java.util.Objects;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.shared.annotations.security.PermissionCheck;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.SearchException;

@Component
public class OpenGroupCondition
implements PermissionCheck {
    public boolean checkIgnorePermission(Object[] values, Object target, WebContext.LocalWebContext context) {
        for (Object value : values) {
            MagicRequest magicRequest;
            boolean hasGroupParameter;
            if (!(value instanceof MagicRequest) || !(hasGroupParameter = (magicRequest = (MagicRequest)value).getQuery().stream().anyMatch(query -> "group".equals(query.getField())))) continue;
            Long groupId = magicRequest.getQuery().stream().filter(query -> "group".equals(query.getField()) && query.getValue() != null).map(query -> this.convertToLong(query.getValue())).findFirst().orElseThrow(() -> new SearchException("group"));
            GroupModel groupModel = (GroupModel)((GroupRepo)context.getBean(GroupRepo.class)).findById((Object)groupId).orElseThrow(() -> new ItemNotFoundException(groupId));
            if (!Objects.equals(groupModel.getOpen(), true)) continue;
            return true;
        }
        return false;
    }

    private Long convertToLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }
}

